/**
 * This file is part of Moodle - http://moodle.org/
 *
 * Moodle is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Moodle is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Moodle.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @package
 * @copyright Copyright (c) 2015 Open LMS (https://www.openlms.net)
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */
define("theme_snap/section_asset_management",["jquery","core/log","core/ajax","core/str","core/templates","core/notification","theme_snap/util","theme_snap/ajax_notification","theme_snap/footer_alert","core_filters/events","core/fragment","core/modal_copy_to_clipboard"],(function($,log,ajax,str,templates,notification,util,ajaxNotify,footerAlert,Event,fragment,ModalCopyToClipboard){var movingObject,ajaxTracker,self=this,movingObjects=[],ajaxing=!1,sectionsProcess=[],moduleCache=null,progressCache=null,setTocObservers=function(){"weeks"!=self.courseConfig.format&&"topics"!=self.courseConfig.format||($("#course-toc .chapter-title").click((function(e){var section=$(e.target).attr("href");void 0!==section&&section.length>0&&getSection(section.split("#section-")[1],0)})),$("#toc-searchables li a").click((function(e){var urlParams=$(e.target).attr("href").split("&"),section=urlParams[0],mod=urlParams[1]||null;section=section.split("#section-")[1],getSection(section,mod)})))},updateMovingMessage=function(){var title;if(1===movingObjects.length){var assetname=$(movingObjects[0]).find(".snap-asset-link .instancename").html();assetname=assetname||M.util.get_string("pluginname","label",assetname),title=M.util.get_string("moving","theme_snap",assetname)}else title=M.util.get_string("movingcount","theme_snap",movingObjects.length);footerAlert.setTitle(title)},updateSectionDropMsg=function(sectionName){void 0!==movingObjects&&movingObjects.length>0&&($(".section-drop").each((function(){var sectionDropMsg=M.util.get_string("movingdropsectionhelp","theme_snap",{moving:sectionName,before:$(this).data("title")});$(this).html(sectionDropMsg)})),footerAlert.setSrNotice(M.util.get_string("movingstartedhelp","theme_snap",sectionName)))},getSection=function(section,mod){if(0==$("#section-"+section).length&&-1==sectionsProcess.indexOf(section)){sectionsProcess.push(section);var params={courseid:self.courseConfig.id,section:section};$(".sk-fading-circle").show(),$(".course-content ."+self.courseConfig.format+' li[id^="section-"]').hide(),fragment.loadFragment("theme_snap","section",self.courseConfig.contextid,params).done((function(html,js){var node=$(html);renderSection(section,node,mod,js);var folders=node.find("li.snap-activity.modtype_folder");$.each(folders,(function(index,folder){var content=$(folder).find("div.contentwithoutlink div.snap-assettype");if(content.length>0&&0==$(folder).find("div.activityinstance div.snap-header-card .asset-type").length){var folderAssetTypeHeader=$(folder).find("div.activityinstance div.snap-header-card");content.prependTo(folderAssetTypeHeader)}}))}))}},renderSection=function(section,html,mod,js){var anchor=$(".course-content"),existingSections=[];anchor.find("li[id^=section-]").each((function(){existingSections.push(parseInt($(this).attr("id").split("section-")[1]))}));var tempnode=$("<div></div>");if(templates.replaceNodeContents(tempnode,html,""),tempnode.find(".snap-header-card .snap-header-card-icons .disabled-snap-asset-completion-tracking").remove(),existingSections.length>0){var closest=existingSections.reduce((function(prev,curr){return Math.abs(curr-section)<Math.abs(prev-section)?curr:prev}));closest>section?anchor.find("#section-"+closest).before(tempnode.find('li[id^="section-"]')):anchor.find("#section-"+closest).after(tempnode.find('li[id^="section-"]'))}else $(".sk-fading-circle").after(tempnode);templates.runTemplateJS(js),$(".sk-fading-circle").hide(),Event.notifyFilterContentUpdated($(".course-content ."+self.courseConfig.format));var sections=anchor.find('li[id^="section-"]');sections.removeClass("state-visible");var id="#section-"+section;if($(id).addClass("state-visible"),"top"==self.courseConfig.toctype&&"topics"==self.courseConfig.format&&section>0){var title=$(id).find(".sectionname").html(),elements=$(".chapter-title"),tmpid=0;$.each(elements,(function(key,element){$(element).attr("href").split("#section-")[1]==section&&(tmpid=key)})),$(id).find(".sectionname").html(title),$(id).find(".sectionnumber").html(tmpid+".")}sections.show(),$(id).find(".section_footer .next_section, .section_footer .icon-arrow-right, .section_footer .previous_section, .section_footer .icon-arrow-left").click((function(e){var section=$(e.target).attr("section-number");void 0!==section&&section.length>0&&getSection(section,0)})),$(id).find(".section_footer .text").click((function(e){var section=$(e.target).find(".nav_guide").attr("section-number");void 0!==section&&section.length>0&&getSection(section,0)})),$(id+" .section-modchooser-link").click((function(){var sectionNum=$(this).attr("data-sectionid");$(".snap-modchooser-addlink").each((function(){var newLink=this.href.replace(/(section=)[0-9]+/gi,"$1"+sectionNum);$(this).attr("href",newLink)}))})),0!=mod&&void 0!==mod&&function(modid){$("#toc-search-results").html("");var targmod=$("#"+modid.replace("#",""));util.scrollToElement(targmod);var searchpin=$("#searchpin");searchpin.length||(searchpin=$('<i id="searchpin"></i>')),$(targmod).find(".instancename").prepend(searchpin),$(targmod).attr("tabindex","-1").focus(),$("#course-toc").removeClass("state-visible")}(mod);var sectionName=$("#region-main .section-moving").find(".sectionname").text();void 0!==sectionName&&sectionName.length>0&&updateSectionDropMsg(sectionName);var movingId=$("#region-main .section-moving").attr("id");void 0!==movingId&&movingId.length>0&&$("#section-"+(parseInt(movingId.split("section-")[1])+1)+" .snap-drop.section-drop").removeClass("partial-render"),$("#course-toc #chapters li").removeClass("snap-visible-section"),$('#course-toc .chapter-title[href="#section-'+section+'"]').parent("li").addClass("snap-visible-section"),$(id).find("ul.section").append('<li class="snap-drop asset-drop"><div class="asset-wrapper"><a href="#">'+M.util.get_string("movehere","theme_snap")+"</a></div></li>")};return{init:function(courseLib){self.courseConfig=courseLib.courseConfig;ajaxTracker=new function(){var triggersByKey={};this.start=function(jsPendingKey,trigger,subSelector){return this.ajaxing(jsPendingKey)?(log.debug("Skipping ajax request for "+jsPendingKey+", AJAX already in progress"),!1):(M.util.js_pending(jsPendingKey),triggersByKey[jsPendingKey]={trigger:trigger,subSelector:subSelector},trigger&&(subSelector?$(trigger).find(subSelector).addClass("ajaxing"):$(trigger).addClass("ajaxing")),!0)},this.ajaxing=function(jsPendingKey){return M.util.pending_js.indexOf(jsPendingKey)>-1},this.complete=function(jsPendingKey){var trigger,subSelector;triggersByKey[jsPendingKey]&&(trigger=triggersByKey[jsPendingKey].trigger,subSelector=triggersByKey[jsPendingKey].subSelector),trigger&&(subSelector?$(trigger).find(subSelector).removeClass("ajaxing"):$(trigger).removeClass("ajaxing")),delete triggersByKey[jsPendingKey],M.util.js_complete(jsPendingKey)}};var sectionNumber=function(el){return self.courseConfig.partialrender?parseInt($(el).attr("id").split("section-")[1]):parseInt($(el).attr("id").replace("section-",""))},parentSectionNumber=function(el){return sectionNumber($(el).parents("li.section.main")[0])},stopMoving=function(){$("body").removeClass("snap-move-inprogress"),$("body").removeClass("snap-move-section"),$("body").removeClass("snap-move-asset"),footerAlert.hideAndReset(),$(".section-moving").removeClass("section-moving"),$(".asset-moving").removeClass("asset-moving"),$(".snap-asset a").removeAttr("tabindex"),$(".snap-asset button").removeAttr("disabled"),$(".js-snap-asset-move").removeAttr("checked"),$(".snap-asset-move-input").prop("checked",!1),$(".readmore-container").removeAttr("hidden"),movingObjects=[],self.courseConfig.partialrender&&$(".snap-drop.section-drop").addClass("partial-render")},moveFailed=function(){var actname=$(movingObject).find(".instancename").html();footerAlert.removeAjaxLoading(),footerAlert.setTitle(M.util.get_string("movefailed","theme_snap",actname)),window.setTimeout((function(){stopMoving()}),2e3)},ajaxReqMoveGeneral=function(params,onSuccess,finalItem){if(ajaxing)log.debug("Skipping ajax request, one already in progress");else{footerAlert.addAjaxLoading(),params.sesskey=M.cfg.sesskey,params.courseId=courseLib.courseConfig.id,params.field="move",log.debug("Making course/rest.php request",params);var req=$.ajax({type:"POST",async:!0,data:params,url:M.cfg.wwwroot+courseLib.courseConfig.ajaxurl});req.done((function(data){ajaxNotify.ifErrorShowBestMsg(data).done((function(errorShown){if(errorShown)return log.debug("Ajax request fail"),void moveFailed();log.debug("Ajax request successful"),onSuccess&&onSuccess(),finalItem&&"resource"===params.class&&(stopMoving(),$(".snap-asset-move-wrapper").attr("hidden","hidden"),$(movingObject).find("label.snap-asset-move-label > input.js-snap-asset-move").focus())}))})),req.fail((function(){moveFailed()})),finalItem&&req.always((function(){ajaxing=!1,footerAlert.removeAjaxLoading()}))}},getSectionTitle=function(section){return self.courseConfig.partialrender?$('#course-toc #chapters > h3 li a[href="#section-'+section+'"]').text():$("#chapters h3:nth-of-type("+(section+1)+") .chapter-title").html()},updateSectionNavigation=function(selector){var sections,totalSectionCount,dfd=$.Deferred();if(selector){if(sections=$(selector),self.courseConfig.partialrender)var allSections=$("#course-toc #chapters > h3 li a");else allSections=$("#region-main .course-content > ul li.section");totalSectionCount=allSections.length}else selector=self.courseConfig.partialrender?"#course-toc #chapters > h3 li a":"#region-main .course-content > ul li.section",sections=$(selector),totalSectionCount=sections.length;var completed=0;return $.each(sections,(function(idx,el){if(self.courseConfig.partialrender){var href=$(el).attr("href");sectionNum=void 0!==href&&!1!==href?parseInt($(el).attr("href").split("#section-")[1]):parseInt($(el).attr("id").split("section-")[1])}else var sectionNum=sectionNumber(el);var extraclasses,previousSection=sectionNum-1,nextSection=sectionNum+1,previous=!1,next=!1;previousSection>-1&&(extraclasses=(self.courseConfig.partialrender?$("#section-"+previousSection).hasClass("draft"):$("#section-"+previousSection).hasClass("hidden"))?" dimmed_text":"",previous={section:previousSection,title:getSectionTitle(previousSection),classes:extraclasses}),nextSection<totalSectionCount&&(extraclasses=(self.courseConfig.partialrender?$("#section-"+nextSection).hasClass("draft"):$("#section-"+nextSection).hasClass("hidden"))?" dimmed_text":"",next={section:nextSection,title:getSectionTitle(nextSection),classes:extraclasses});var navigation={previous:previous,next:next};templates.render("theme_snap/course_section_navigation",navigation).done((function(result){var target=$("#section-"+sectionNum+" .section_footer");target.length>0&&target.replaceWith(result),++completed===sections.length&&dfd.resolve()}))})),dfd.promise()},updateSections=function(current,target,predeleteSections,deletedSection){if(courseLib.courseConfig.partialrender){var loadedSections=[],sections=[];if(0!=current&&0!=target){$.each($("#course-toc #chapters > li a"),(function(idx,obj){sections.push($(obj).attr("href").split("#section-")[1])}));var newOrder=function(sections,oldIndex,newIndex){if(newIndex>=sections.length)for(var k=newIndex-sections.length+1;k--;)sections.push(void 0);return sections.splice(newIndex,0,sections.splice(oldIndex,1)[0]),sections}(sections,current,target)}else{sections=predeleteSections,predeleteSections.splice(deletedSection,1);newOrder=predeleteSections}$.each($("#region-main .course-content > ul li.section"),(function(idx,obj){var value=$(obj).attr("id").split("section-")[1],key=newOrder.indexOf(value),chapterTitle=getSectionTitle(key),fullTitle=chapterTitle;$(obj).attr("id","section-"+key),"top"==self.courseConfig.toctype&&"topics"==self.courseConfig.format&&key>0&&(fullTitle="<span class='sectionnumber'> ".concat(key,".</span>").concat(chapterTitle)),$("#section-"+key+" .content .sectionname").html(fullTitle),loadedSections.push(key),$(obj).find(".section-modchooser-link").attr("data-sectionid",key)})),sectionsProcess=loadedSections}else $.each($("#region-main .course-content > ul li.section"),(function(idx,obj){$(obj).attr("id","section-"+idx);var chapterTitle=getSectionTitle(idx),fullTitle=chapterTitle;"top"==self.courseConfig.toctype&&"topics"==self.courseConfig.format&&idx>0&&(fullTitle="<span class='sectionnumber'></span>".concat(chapterTitle)),$("#section-"+idx+" .content .sectionname").html(fullTitle),$(this).find(".section-modchooser-link").attr("data-sectionid",idx)}));updateSectionNavigation().done((function(){courseLib.courseConfig.partialrender&&setCourseSectionObervers()}))},ajaxReqMoveAsset=function(target){var params={};log.debug("Move objects",movingObjects),params.class="resource",updateMovingMessage(),movingObject=movingObjects.shift(),params.id=Number(movingObject.id.replace("module-","")),target&&!$(target).hasClass("snap-drop")?params.beforeId=Number($(target)[0].id.replace("module-","")):params.beforeId=0,"page-site-index"===document.body.id?params.sectionId=1:params.sectionId=parentSectionNumber(target||movingObject),movingObjects.length>0?ajaxReqMoveGeneral(params,(function(){$(target).before($(movingObject)),ajaxReqMoveAsset(target)}),!1):ajaxReqMoveGeneral(params,(function(){$(target).before($(movingObject))}),!0)},assetEditListeners=function(){$(document).on("click",".snap-asset-actions .js_snap_hide, .snap-asset-actions .js_snap_show, .snap-asset-actions .js_snap_delete, .snap-asset-actions .js_snap_duplicate,.snap-asset-actions .js_snap_stealth",(function(e){!function(e,triggerEl){e.preventDefault();var assetEl=$($(triggerEl).parents(".snap-asset")[0]),cmid=Number(assetEl[0].id.replace("module-","")),instanceName=assetEl.find(".instancename").text().trim(),action=$(triggerEl).data("action"),errActionKey="",errMessageKey="",errAction="",errMessage="",jsPendingKey="asset_"+action;if(!ajaxTracker.ajaxing(jsPendingKey)){var actionAJAX=function(){if(ajaxTracker.start(jsPendingKey,assetEl,".snap-edit-asset-more")){var params={action:action,sectionreturn:0,id:cmid};ajax.call([{methodname:"core_course_edit_module",args:params}],!0,!0)[0].done((function(response){ajaxNotify.ifErrorShowBestMsg(response,errAction,errMessage).done((function(errorShown){ajaxTracker.complete(jsPendingKey),errorShown?log.debug("Ajax request fail"):(log.debug("Ajax request successful"),moduleCache=null,progressCache=null,"delete"===action?(assetEl.remove(),$('#toc-searchables li[data-id="'+cmid+'"]').remove()):"show"===action?(assetEl.removeClass("draft"),assetEl.removeClass("stealth")):"hide"===action?(assetEl.removeClass("stealth"),assetEl.addClass("draft")):"duplicate"===action?assetEl.replaceWith(response):"stealth"===action&&(assetEl.addClass("stealth"),assetEl.removeClass("draft")))}))})).fail((function(response){ajaxNotify.ifErrorShowBestMsg(response,errAction,errMessage).done((function(){ajaxTracker.complete(jsPendingKey)}))})).always((function(){footerAlert.hideAndReset()}))}};("duplicate"===action?(errActionKey="action:duplicateasset",errMessageKey="error:failedtoduplicateasset"):"show"===action||"hide"===action?(errActionKey="action:changeassetvisibility",errMessageKey="error:failedtochangeassetvisibility"):"delete"===action&&(errActionKey="action:deleteasset",errMessageKey="error:failedtodeleteasset"),str.get_strings([{key:errActionKey,component:"theme_snap"},{key:errMessageKey,component:"theme_snap"}])).then((function(strings){if(errAction=strings[0],errMessage=strings[0],"delete"===action){var delConf="",plugindata={type:M.util.get_string("pluginname",assetEl.attr("class").match(/modtype_([^\s]*)/)[1])};""!==instanceName?(plugindata.name=instanceName,delConf=M.util.get_string("deletechecktypename","moodle",plugindata)):delConf=M.util.get_string("deletechecktype","moodle",plugindata);var delTitle=M.util.get_string("confirm","moodle"),ok=M.util.get_string("deleteassetconfirm","theme_snap",plugindata.type),cancel=M.util.get_string("cancel","moodle");notification.confirm(delTitle,delConf,ok,cancel,actionAJAX)}else actionAJAX()}))}}(e,this)}))},sectionActionListener=function(action,onComplete){let selector=".snap-section-editing.actions .snap-"+action;$(".snap-section-editing.actions .snap-"+action).parents(".dropdown-item").length>0&&(selector=".snap-section-editing.actions .dropdown-item:has(.snap-"+action+")"),$("#region-main").on("click",selector,(function(e){const activeDropdownSel="#extra-actions-dropdown-"+parentSectionNumber(this);$(activeDropdownSel).dropdown().parent().hasClass("show")&&$(activeDropdownSel).dropdown("toggle"),e.stopPropagation(),e.preventDefault();var trigger=this;if(-1===["visibility","highlight"].indexOf(action))throw new function(action){this.message="Invalid section action: "+action,this.name="invalidActionException"}(action);if(ajaxTracker.start("section_"+action,trigger)){var toggle,loadModules=!0;"visibility"===action?(toggle=$(this).hasClass("snap-hide")?0:1,moduleCache&&moduleCache.length>0&&progressCache&&progressCache.length>0&&(loadModules=!1)):toggle="true"===$(this).attr("aria-pressed")?0:1;var sectionNumber=parentSectionNumber(this),actionSelector="#section-"+sectionNumber+" .snap-section-editing"+" .snap-"+action;ajax.call([{methodname:"theme_snap_course_sections",args:{courseshortname:courseLib.courseConfig.shortname,action:action,sectionnumber:sectionNumber,value:toggle,loadmodules:loadModules}}],!0,!0)[0].fail((function(response){var errMessage,errAction;"visibility"===action?(errMessage=M.util.get_string("error:failedtochangesectionvisibility","theme_snap"),errAction=M.util.get_string("action:changesectionvisibility","theme_snap")):(errMessage=M.util.get_string("error:failedtohighlightsection","theme_snap"),errAction=M.util.get_string("action:highlightsectionvisibility","theme_snap")),ajaxNotify.ifErrorShowBestMsg(response,errAction,errMessage).done((function(){ajaxTracker.complete("section_"+action)}))})).always((function(){$(trigger).removeClass("ajaxing")})).done((function(response){return $(actionSelector).parents(".dropdown-item").length>0&&(response.actionmodel.isinmenu=!0),templates.render("theme_snap/course_action_section",response.actionmodel).then((function(result){if($(actionSelector).parents(".dropdown-item").length>0?$(actionSelector).parent().parent("li").replaceWith(result):($(actionSelector).parent("li").replaceWith(result),$(actionSelector).focus()),!loadModules&&(moduleCache&&moduleCache.length>0&&0===response.toc.modules.length&&(response.toc.modules=moduleCache),progressCache&&progressCache.length>0)){var progressCacheCopy=progressCache.slice(0);$.each(response.toc.chapters.chapters,(function(index){response.toc.chapters.chapters[index].progress=progressCacheCopy.shift()}))}return loadModules&&(moduleCache=response.toc.modules,progressCache=[],$.each(response.toc.chapters.chapters,(function(index,value){progressCache.push(value.progress)}))),templates.render("theme_snap/course_toc",response.toc)})).then((function(result){if($("#course-toc").html($(result).html()),$(document).trigger("snapTOCReplaced"),onComplete&&"function"==typeof onComplete){var completion=onComplete(sectionNumber,toggle);self.courseConfig.partialrender?"function"==typeof onComplete&&ajaxTracker.complete("section_"+action):completion&&"function"==typeof completion.always?completion.always((function(){ajaxTracker.complete("section_"+action)})):ajaxTracker.complete("section_"+action)}else ajaxTracker.complete("section_"+action)}))}))}}))},deleteSectionListener=function(){$(document).on("click",".snap-section-editing.actions .snap-delete",(function(e){!function(e,el){e.preventDefault();var sectionNum=parentSectionNumber(el),section=$("#section-"+sectionNum),sectionName=section.find(".sectionname").text(),delTitle=M.util.get_string("confirm","moodle"),delConf=M.util.get_string("confirmdeletesection","moodle",sectionName),ok=M.util.get_string("deletesectionconfirm","theme_snap"),cancel=M.util.get_string("cancel","moodle");notification.confirm(delTitle,delConf,ok,cancel,(function(){if(ajaxTracker.start("section_delete",el)){var delProgress=M.util.get_string("deletingsection","theme_snap",sectionName);footerAlert.addAjaxLoading(""),footerAlert.show(),footerAlert.setTitle(delProgress);var params={courseshortname:courseLib.courseConfig.shortname,action:"delete",sectionnumber:sectionNum,value:1,loadmodules:!0};log.debug("Making course/rest.php section delete request",params);var ajaxPromises=ajax.call([{methodname:"theme_snap_course_sections",args:params}],!0,!0),sections=[];$.each($("#course-toc #chapters > li a"),(function(idx,obj){sections.push($(obj).attr("href").split("#section-")[1])})),ajaxPromises[0].done((function(response){templates.render("theme_snap/course_toc",response.toc).done((function(result){if($("#course-toc").html($(result).html()),$(document).trigger("snapTOCReplaced"),section.remove(),updateSections(0,0,sections,sectionNum),self.courseConfig.partialrender){var chapters=$(".chapter-title"),ids=[];$.each(chapters,(function(key,element){ids.push($(element).attr("href").split("#section-")[1])}));var closest=ids.reduce((function(prev,curr){return Math.abs(curr-sectionNum)<Math.abs(prev-sectionNum)?curr:prev}));location.hash="section-"+closest,1==$("li#section-"+closest).length?courseLib.showSection():getSection(closest,0)}else sectionNum>=$(".course-content > ul li.section").length&&(location.hash="section-"+(sectionNum-1)),courseLib.showSection();ajaxTracker.complete("section_delete")})).always((function(){footerAlert.hideAndReset()})).fail((function(){ajaxTracker.complete("section_delete")}))})).fail((function(response){ajaxNotify.ifErrorShowBestMsg(response),footerAlert.hideAndReset(),ajaxTracker.complete("section_delete")}))}}))}(e,this)}))},footerAlertShowMove=function(){let focusEl=arguments.length>0&&void 0!==arguments[0]?arguments[0]:null;footerAlert.show((function(e){e.preventDefault(),stopMoving(),$(".snap-asset-move-wrapper").attr("hidden","hidden"),null!==focusEl&&focusEl.focus()}))},assetMoveListener=function(){$("#region-main").on("change",".js-snap-asset-move",(function(e){e.stopPropagation();var obj,index,asset=$(this).parents(".snap-asset")[0],section=$(asset).parents("ul.section")[0],afterdrop=$(section).find("li.snap-drop.asset-drop");if($(section).append(afterdrop),0===movingObjects.length){$(".snap-asset-move-wrapper").removeAttr("hidden"),$(".readmore-container").attr("hidden","hidden");var assetname=$(asset).find(".snap-asset-link .instancename").html();log.debug("Moving this asset",assetname);var classes=$(asset).attr("class"),assetclasses=/(?=snap-mime)([a-z0-9\-]*)/.exec(classes);classes="",assetclasses&&(classes=assetclasses.join(" ")),log.debug("Moving this class",classes),$(asset).addClass("asset-moving"),$(".snap-asset button").attr("disabled","disabled"),$(asset).find("button").removeAttr("disabled"),$(".snap-asset .snap-asset-content a").attr("tabindex","-1"),$(".snap-asset .mod-link").attr("tabindex","-1"),$(asset).find("a").removeAttr("tabindex"),$(asset).find(".js-snap-asset-move").prop("checked","checked"),$("body").addClass("snap-move-inprogress"),$("body").addClass("snap-move-asset")}$(this).prop("checked")?(movingObjects.push(asset),$(asset).find("a").removeAttr("tabindex"),$(asset).find("button").removeAttr("disabled"),$(asset).addClass("asset-moving")):(obj=asset,(index=movingObjects.indexOf(obj))>-1&&movingObjects.splice(index,1),updateMovingMessage(),$(asset).find(".snap-asset-content a").attr("tabindex","-1"),$(asset).find("button").attr("disabled","disabled"),$(asset).removeClass("asset-moving"),0===movingObjects.length&&stopMoving()),footerAlertShowMove($(this)),updateMovingMessage()}))},movePlaceListener=function(){$(document).on("click",".snap-move-note, .snap-drop",(function(e){var target,domTargetSection,currentSection,targetSection;(log.debug("Snap drop clicked",e),movingObjects)&&(e.stopPropagation(),e.preventDefault(),$("body").hasClass("snap-move-section")?(domTargetSection=parentSectionNumber(this),currentSection=sectionNumber(movingObjects[0]),ajaxReqMoveGeneral({class:"section",id:currentSection,value:targetSection=currentSection<domTargetSection?domTargetSection-1:domTargetSection},(function(){ajax.call([{methodname:"theme_snap_course_toc_chapters",args:{courseshortname:courseLib.courseConfig.shortname},done:function(response){templates.render("theme_snap/course_toc_chapters",response.chapters).done((function(result){$("#chapters").replaceWith(result),$("#section-"+domTargetSection).before($("#section-"+currentSection)),updateSections(currentSection,targetSection,[],null),location.hash="section-"+targetSection,courseLib.showSection(),stopMoving()}))},fail:function(response){ajaxNotify.ifErrorShowBestMsg(response),stopMoving()}}],!0,!0)}),!0)):(target=$(this).hasClass("snap-drop")?this:$(this).closest(".snap-asset"),ajaxReqMoveAsset(target)))}))},setCourseSectionObervers=function(){setTocObservers(),"weeks"!=self.courseConfig.format&&"topics"!=self.courseConfig.format||($(".section_footer .next_section, .section_footer .icon-arrow-right, .section_footer .previous_section, .section_footer .icon-arrow-left").click((function(e){var section=$(e.target).attr("section-number");void 0!==section&&section.length>0&&getSection(section,0)})),$(".section_footer .text").click((function(e){var section=$(e.target).find(".nav_guide").attr("section-number");void 0!==section&&section.length>0&&getSection(section,0)})))},addListeners=function(){$("#region-main").on("click",".snap-section-editing.actions .snap-move",(function(e){e.stopPropagation(),e.preventDefault(),$("body").addClass("snap-move-inprogress"),footerAlertShowMove();var sectionNumber=parentSectionNumber(this);log.debug("Section is",sectionNumber);var section=$("#section-"+sectionNumber),sectionName=section.find(".sectionname").text();log.debug("Moving this section",sectionName),movingObjects=[section],$(".section-moving").removeClass("section-moving"),section.addClass("section-moving"),$('a[href="#section-'+sectionNumber+'"]').parent("li").addClass("section-moving"),$("body").addClass("snap-move-section"),self.courseConfig.partialrender&&$("#section-"+(sectionNumber+1)+" .snap-drop.section-drop").removeClass("partial-render");var title=M.util.get_string("moving","theme_snap",sectionName);footerAlert.setTitle(title),updateSectionDropMsg(sectionName)})),sectionActionListener("visibility",(function(sectionNumber,toggle){0===toggle?$("#section-"+sectionNumber).addClass("hidden"):($("#section-"+sectionNumber).removeClass("hidden"),$("#section-"+sectionNumber+" .stealth-section-hidden").removeClass("stealth"),$("#section-"+sectionNumber+" .stealth-section-hidden").removeClass("stealth-section-hidden"));var selector=["#section-"+(sectionNumber-1),"#section-"+(sectionNumber+1)].join(",");return updateSectionNavigation(selector)})),sectionActionListener("highlight",(function(sectionNumber){$("#section-"+sectionNumber).toggleClass("current"),$("li.section.main").not("#section-"+sectionNumber).not("#section-0").removeClass("current").each((function(){var highlighter=$(this).find(".snap-highlight"),sectionNumber=parentSectionNumber(highlighter);let highlighterref="";$(highlighter).parents(".dropdown-item").length>0?(highlighterref=$(highlighter).parent().attr("href").replace(/(marker=)[0-9]+/gi,"$1"+sectionNumber),$(highlighter).parent().attr("href",highlighterref).attr("aria-pressed","false")):(highlighterref=$(highlighter).attr("href").replace(/(marker=)[0-9]+/gi,"$1"+sectionNumber),$(highlighter).attr("href",highlighterref).attr("aria-pressed","false"))}))})),deleteSectionListener(),$(document).on("click",".snap-section-editing.actions .snap-permalink",(function(e){e.preventDefault(),ModalCopyToClipboard.create({text:this.parentNode.getAttribute("href")},str.get_string("sectionlink","course"))})),assetMoveListener(),movePlaceListener(),assetEditListeners(),$(document).on("click","#availability-menu .choicelist div[data-optionnumber]",(function(e){e.preventDefault();const cmIds=[];let courseId=self.courseConfig.id,dataId=$(this).find(".option-name a").attr("data-id"),dataAction=$(this).find(".option-name a").attr("data-action"),url=$(this).find(".option-name a").attr("href");"cmShow"===dataAction?dataAction="cm_show":"cmHide"===dataAction?dataAction="cm_hide":"cmStealth"===dataAction&&(dataAction="cm_stealth"),cmIds.push(dataId),ajax.call([{methodname:"core_courseformat_update_course",args:{action:dataAction,courseid:courseId,ids:cmIds},done:function(res){let cmid=(res=JSON.parse(res))[0].fields.id,module=$("#module-"+cmid);if(module.find('#availability-menu .selected .option-select-indicator [data-for="checkedIcon"]').addClass("d-none"),module.find('#availability-menu .selected .option-select-indicator [data-for="uncheckedIcon"]').removeClass("d-none"),module.find("#availability-menu .selected").removeClass("border bg-primary-light selected"),res[0].fields.visible)if(res[0].fields.stealth){module.addClass("stealth"),module.removeClass("draft");var selected=module.find('#availability-menu a[data-action="cmStealth"]')}else module.removeClass("stealth"),module.removeClass("draft"),selected=module.find('#availability-menu a[data-action="cmShow"]');else module.addClass("draft"),module.removeClass("stealth"),selected=module.find('#availability-menu a[data-action="cmHide"]');selected.parents("div[data-optionnumber][data-selected]").addClass("border bg-primary-light selected");let indicator=selected.parent().siblings(".option-select-indicator");indicator.find('span[data-for="checkedIcon"]').removeClass("d-none"),indicator.find('span[data-for="uncheckedIcon"]').addClass("d-none")},fail:function(reason){"nopermissions"===reason.errorcode?window.open(url,"_self"):ajaxNotify.ifErrorShowBestMsg(reason)}}])})),$(document).on("click","#snap-groups-menu .dropdown-item-outline, .groups-dropdown-menu .dropdown-item-outline",(function(e){e.preventDefault();const cmIds=[];let courseId=self.courseConfig.id,dataId=$(this).find(".option-name a").attr("data-id"),dataAction=$(this).find(".option-name a").attr("data-action"),dataOptionNumber=$(this).attr("data-optionnumber"),actionText="";"cmNoGroups"===dataAction?(dataAction="cm_nogroups",actionText=M.util.get_string("groupsnone","moodle")):"cmSeparateGroups"===dataAction?(dataAction="cm_separategroups",actionText=M.util.get_string("groupsseparate","moodle")):"cmVisibleGroups"===dataAction&&(dataAction="cm_visiblegroups",actionText=M.util.get_string("groupsvisible","moodle")),cmIds.push(dataId),ajax.call([{methodname:"core_courseformat_update_course",args:{action:dataAction,courseid:courseId,ids:cmIds},done:function(){let activityCard=$("#module-"+dataId),selectedIconUrl=$(activityCard).find("[data-optionnumber="+dataOptionNumber+"] .option-icon img").attr("src");$(activityCard).find(".snap-activity-groups-dropdown .snap-groups-more img").attr("src",selectedIconUrl),$(activityCard).find(".snap-activity-groups-dropdown .snap-groups-more img").attr("alt",actionText),$(activityCard).find("#snap-groups-menu .border.bg-primary-light.selected,.groups-dropdown-menu .border.bg-primary-light.selected").removeClass("border bg-primary-light selected"),$(activityCard).find("#snap-groups-menu a.selected,.groups-dropdown-menu a.selected").removeClass("selected"),$(activityCard).find('.option-select-indicator [data-for="checkedIcon"]').addClass("d-none"),$(activityCard).find('.option-select-indicator [data-for="uncheckedIcon"]').removeClass("d-none"),$(activityCard).find("[data-optionnumber="+dataOptionNumber+"]").addClass("border bg-primary-light selected"),$(activityCard).find(".groups-dropdown-menu a[data-id="+dataId+"], #snap-groups-menu a.selected").addClass("selected"),$(activityCard).find("[data-optionnumber="+dataOptionNumber+'] .option-select-indicator [data-for="checkedIcon"]').removeClass("d-none"),$(activityCard).find("[data-optionnumber="+dataOptionNumber+'] .option-select-indicator  [data-for="uncheckedIcon"]').addClass("d-none")}}])})),$(document).on("click",".dropdown-subpanel",(function(e){e.stopPropagation(),$(".dropdown-subpanel").not(this).find(".dropdown-subpanel-content").hide(),$(".dropdown-subpanel").not(this).find(".dropdown-toggle").removeClass("active"),$(this).find(".dropdown-toggle").hasClass("active")?($(this).parent().parent().click(),$(this).parent().parent().blur(),$(this).find(".dropdown-subpanel-content").hide(),$(this).find(".dropdown-toggle").removeClass("active")):($(this).find(".dropdown-subpanel-content").show(),$(this).find(".dropdown-toggle").addClass("active"))})),$(document).on("click",(function(event){var subPanelElement=$(".dropdown-subpanel");subPanelElement.is(event.target)||subPanelElement.has(event.target).length||($("#snap-asset-menu .dropdown-subpanel-content").hide(),$("#snap-asset-menu .dropdown-toggle").removeClass("active"))})),"page-site-index"===document.body.id?$("#region-main .sitetopic ul.section").append('<li class="snap-drop asset-drop"><div class="asset-wrapper"><a href="#">'+M.util.get_string("movehere","theme_snap")+"</a></div></li>"):$("li.section .content ul.section").append('<li class="snap-drop asset-drop"><div class="asset-wrapper"><a href="#">'+M.util.get_string("movehere","theme_snap")+"</a></div></li>"),courseLib.courseConfig.partialrender&&setCourseSectionObervers(),$("body").addClass("snap-course-listening")};addListeners(),function(){if(0!==$(".snap-section-editing.actions").length){var trigger=$("#region-main");ajaxTracker.start("section_toc",trigger)&&ajax.call([{methodname:"theme_snap_course_sections",args:{courseshortname:courseLib.courseConfig.shortname,action:"toc",sectionnumber:0,value:0,loadmodules:0}}],!0,!0)[0].fail((function(response){var errMessage,errAction;errMessage=M.util.get_string("error:failedtotoc","theme_snap"),errAction=M.util.get_string("action:sectiontoc","theme_snap"),ajaxNotify.ifErrorShowBestMsg(response,errAction,errMessage).done((function(){ajaxTracker.complete("section_toc")}))})).always((function(){$(trigger).removeClass("ajaxing")})).done((function(response){moduleCache=response.toc.modules,progressCache=[],$.each(response.toc.chapters.chapters,(function(index,value){progressCache.push(value.progress)})),ajaxTracker.complete("section_toc")}))}}(),util.whenTrue((function(){return M.course&&M.course.init_section_toolbox}),(function(){M.course&&M.course.resource_toolbox&&(M.course.resource_toolbox.handle_resource_dim=function(button,activity,action){return"hide"===action?0:1})}),!0)},renderAndFocusSection:function(section,mod){getSection(section,mod)},setTocObserver:function(){setTocObservers()}}}));

//# sourceMappingURL=section_asset_management.min.js.map