<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @copyright  Copyright (c) 2024 Open LMS (https://www.openlms.net)
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutcourse'] = 'Acerca de este curso';
$string['activity'] = 'Actividad';
$string['action:changeassetvisibility'] = 'cambiar visibilidad de curso';
$string['action:duplicateasset'] = 'activo duplicado';
$string['action:changesectionvisibility'] = 'cambiar visibilidad de curso';
$string['action:highlightsectionvisibility'] = 'resaltar visibilidad de sección';
$string['action:sectiontoc'] = 'obtener tabla de contenido con secciones';
$string['addanewsection'] = 'Crear una nueva sección';
$string['addresourceoractivity'] = 'Crear actividad de aprendizaje';
$string['admin'] = 'Admin';
$string['advancedbrandingheading'] = 'Creación de marca avanzada';
$string['ago'] = 'atrás';
$string['answered'] = 'Respondido';
$string['appendices'] = 'Herramientas';
$string['arialabelnewsarticle'] = 'artículo de noticias';
$string['assigndraft'] = 'El borrador requiere su confirmación.';
$string['assignreopened'] = 'Reabierto';
$string['at'] = 'en';
$string['attempted'] = 'Intentos';
$string['basics'] = 'Aspectos básicos';
$string['brandingheading'] = 'Creación de marca';
$string['browse'] = 'Explorar';
$string['browseallcourses'] = 'Explorar todos los cursos';
$string['cachedef_activity_deadlines'] = 'Almacenamiento en memoria caché de fechas límite de actividad de usuarios';
$string['cachedef_generalstaticappcache'] = 'Memoria caché en el nivel de aplicación estática general Snap';
$string['cachedef_course_completion_progress'] = 'Se utiliza para almacenar datos de finalización por curso/usuario en la memoria caché.';
$string['cachedef_course_completion_progress_ts'] = 'Se utiliza para que podamos invalidar memorias caché en el nivel de sesión si se modifican los ajustes de finalización para un curso o módulo.';
$string['cachedef_webservicedefinitions'] = 'Almacenamiento en memoria caché de definiciones de servicio web generadas automáticamente';
$string['card'] = 'Tarjeta';
$string['categoryedit'] = 'Editar categoría';
$string['category_color'] = 'Color de categoría';
$string['category_color_description'] = 'Color de la categoría del curso. Los cursos hijo toman la configuración de la categoría padre más cercana.';
$string['category_color_palette'] = 'Paleta de colores';
$string['category_color_palette_description'] = 'Consulte el valor hexadecimal correspondiente para el color dado. Esto no afectará ninguna configuración, es solo una muestra para ayudar a los usuarios a crear el valor de configuración.';
$string['changecoverimage'] = 'Cambiar imagen de tapa';
$string['changefullname'] = 'Cambiar nombre del sitio';
$string['chapters'] = 'Capítulos';
$string['choosereadme'] = '<div class="clearfix"><div class="theme_screenshot"><h2>Snap</h2><img class=img-polaroid src="snap/pix/screenshot.jpg" /></div></div>';
$string['close'] = 'Cerrar';
$string['conditional'] = 'Condicional';
$string['contents'] = 'Contenido';
$string['contributed'] = 'Contribuido';
$string['courses'] = 'Cursos';
$string['coursecontacts'] = 'Contactos del curso';
$string['coursedisplay'] = 'Visualización del curso';
$string['coursefootertoggle'] = 'Pie de página del curso';
$string['coursefootertoggledesc'] = 'El pie de página del curso muestra a los usuarios información útil en una página del curso, que incluye los contactos del curso, la descripción del curso y la actividad reciente del curso.';
$string['courseformatnotification'] = 'El formato actual de curso no es totalmente compatible con el tema de Snap. Para obtener la mejor experiencia, Open LMS recomienda utilizar los formatos de curso Temas o Semanales con el tema de Snap. El formato de curso se puede cambiar en los <a href="{$a}">ajustes del curso</a>.';
$string['coursefixydefaulttext'] = 'Actualmente, no está inscrito en ningún curso.<br>Los cursos en los que está inscrito se mostrarán aquí.';
$string['coursegrade'] = 'Calificación del curso:';
$string['coursepartialrender'] = 'Habilitar la carga diferida para las secciones del curso';
$string['coursepartialrenderdesc'] = 'Si se habilita esta opción, las secciones del curso se cargan bajo demanda cuando las selecciona un usuario. Esto permite que los cursos con grandes cantidades de contenido se carguen más rápido.';
$string['coursenavigation'] = 'Navegación por los cursos';
$string['coursesummaryfilesunsuitable'] = 'Vacíe los archivos de resumen del curso antes de intentar cambiar la imagen de tapa.';
$string['courseactionslabel'] = 'acciones';
$string['courseactivitieslabel'] = 'Actividades de sección';
$string['coursetools'] = 'Panel de control del curso';
$string['coverdisplay'] = 'Visualización de tapa';
$string['covercarousel'] = 'Carrusel de tapa';
$string['covercarousellabel'] = 'Carrusel';
$string['covercarouselon'] = 'Usar carrusel de tapa';
$string['covercarouseldescription'] = '<p>El carrusel es una serie de banners que rotan o una presentación que se visualiza en la página principal de su sitio en lugar de la imagen de tapa.</p>
<p>Agregue un máximo de 3 imágenes, un título para cada diapositiva y un subtítulo opcional. Las imágenes de 1200 x 600 píxeles funcionan mejor.</p>';
$string['covercarouselsronly'] = 'Se trata de un carrusel con imágenes con rotación automática. Active cualquiera de los botones para desactivar la rotación. Utilice los botones Siguiente y Anterior para desplazarse o saltar a una diapositiva utilizando los puntos de la diapositiva.';
$string['covercarouselplaybutton'] = 'Reanude la rotación automática de las imágenes del carrusel.';
$string['covercarouselpausebutton'] = 'Pause la rotación automática de las imágenes del carrusel.';
$string['coverimage'] = 'Imagen de tapa';
$string['covervideo'] = 'Video de tapa';
$string['comingsoon'] = 'Próximamente';
$string['createsection'] = 'Crear sección';
$string['current'] = 'Actual';
$string['customcss'] = 'CSS personalizado';
$string['customcssdesc'] = 'Tenga en cuenta que mayor funcionalidad conlleva mayor responsabilidad. Si surge un problema con la CSS aquí agregada, será su responsabilidad resolverlo. El servicio de asistencia técnica de Open LMS no soluciona problemas ni brinda ayuda con contenido relacionado con CSS.';
$string['customtopbar'] = 'Barra de navegación';
$string['customisenavbar'] = 'Cambiar los colores de la barra de navegación';
$string['customisenavbutton'] = 'Cambiar los colores del botón Mis cursos';
$string['customisecustommenu'] = 'Cambiar el color del texto del menú personalizado';
$string['custommenutext'] = 'Color del texto del menú personalizado';
$string['deadlines'] = 'Fechas límite';
$string['deadlinestoggle'] = 'Fechas límite';
$string['deadlinestoggledesc'] = 'Mostrar a los usuarios las fechas límite de actividades próximas de los cursos en los que está inscrito.';
$string['defaultsummary'] = 'Utilice esta área para describir de qué se trata el tema con texto, imágenes, audio y vídeo.';
$string['defaultintrosummary'] = 'Le damos la bienvenida a su nuevo curso {$a}.<br>Comience por describir de qué trata el curso con texto, imágenes, audio y vídeo.';
$string['defaulttopictitle'] = 'Tema sin título';
$string['debugerrors'] = 'Depurar errores';
$string['deleteassetconfirm'] = 'Eliminar {$a}';
$string['deletingasset'] = 'Eliminación de {$a} en curso';
$string['deletingassetname'] = 'Eliminación de {$a->type} "{$a->name}" en curso';
$string['deletesectionconfirm'] = 'Eliminar sección';
$string['deletingsection'] = 'Eliminación de la sección "{$a}" en curso';
$string['draft'] = 'No publicado a los estudiantes';
$string['dropzonelabel'] = 'Arrastre y suelte los archivos para adjuntarlos o <span class="fake-link">búsquelos en su equipo</span>';
$string['due'] = 'Vencimiento {$a}';
$string['edit'] = 'Editar "{$a}"';
$string['editcoursecontent'] = 'Editar bloques';
$string['editcoursesettings'] = 'Ajustes del curso';
$string['editcoursetopic'] = 'Editar sección';
$string['editcustomfooter'] = 'Editar pie de página';
$string['editcustommenu'] = 'Editar menú personalizado';
$string['error'] = 'Error';
$string['errorgettingfeed'] = 'Se produjo un error al obtener elementos de la fuente.';
$string['error:categorycolorinvalidjson'] = 'Formato JSON incorrecto para las categorías de los cursos';
$string['error:categorycolorinvalidvalue'] = 'El ID de registro o el valor de color de la categoría "{$a}" no son válidos.';
$string['error:categorynotfound'] = 'No se encontró el registro de la categoría con ID "{$a}".';
$string['error:coverimageexceedsmaxbytes'] = 'La imagen de tapa supera el tamaño de archivo máximo permitido den el nivel del sitio ({$a})';
$string['error:coverimageresolutionlow'] = 'Para lograr la mejor calidad, se recomienda una imagen más grande de, al menos, 1024 píxeles de ancho.';
$string['error:duplicatedcategoryids'] = 'Formato JSON incorrecto, algunos ID están duplicados.';
$string['error:failedtochangeassetvisibility'] = 'Error al mostrar/ocultar activo';
$string['error:failedtochangesectionvisibility'] = 'Error al mostrar/ocultar sección';
$string['error:failedtohighlightsection'] = 'Error al seleccionar la sección';
$string['error:failedtoduplicateasset'] = 'Error al duplicar';
$string['error:failedtodeleteasset'] = 'Error al eliminar activo';
$string['error:failedtotoc'] = 'No se pudo obtener la tabla de contenidos.';
$string['extension'] = 'Extensión {$a}';
$string['facebook'] = 'Facebook';
$string['facebookdesc'] = 'La URL de su página de Facebook.';
$string['favicon'] = 'Ícono favorito';
$string['favicondesc'] = 'Los íconos favoritos aparecen en la barra de dirección del navegador web, en los marcadores del usuario y en los atajos de dispositivos móviles.';
$string['favorite'] = 'Favorito {$a}';
$string['favorited'] = '{$a} en favoritos';
$string['featurespots'] = 'Puntos de funciones';
$string['featurespotsedit'] = 'Editar puntos de funciones';
$string['featurespotshelp'] = '<p>Agregue un máximo de 3 puntos de funciones a la página principal de su sitio para resaltar los principales beneficios para los usuarios existentes y potenciales.</p>
<p>Puede agregar una imagen, un título y una descripción del contenido a cada función. Para ver la función en la portada, debe introducir un título. La imagen y las secciones de descripción del contenido son opcionales.</p>
<p>El tamaño de imagen recomendado es un cuadrado, no superior a 200 px x 200 px.</p>';
$string['featurespotsheading'] = 'Encabezado de puntos de funciones';
$string['featureonetitle'] = 'Título de función 1';
$string['featuretwotitle'] = 'Título de función 2';
$string['featurethreetitle'] = 'Título de función 3';
$string['featureonetitlelink'] = 'Enlace de título de función 1';
$string['featuretwotitlelink'] = 'Enlace de título de función 2';
$string['featurethreetitlelink'] = 'Enlace de título de función 3';
$string['featuretitlelinkdesc'] = 'Escriba la URL con la cual desea vincular este punto de función. Puede agregar enlaces internos o externos en su sitio. Para agregar un enlace interno, cópielo de la URL del sitio e incluya una /. Por ejemplo, un enlace a un curso debería verse así: "/course/view.php?id=160". Para agregar un enlace externo, este debe comenzar con https://';
$string['featureonetitlecb'] = 'Abrir función 1 en una ventana nueva';
$string['featuretwotitlecb'] = 'Abrir función 2 en una ventana nueva';
$string['featurethreetitlecb'] = 'Abrir función 3 en una ventana nueva';
$string['featuretitlecbdesc'] = 'Si esta opción está habilitada, el enlace que se agregó al punto de función se abrirá en una ventana nueva';
$string['featureonetext'] = 'Contenido de función 1';
$string['featuretwotext'] = 'Contenido de función 2';
$string['featurethreetext'] = 'Contenido de función 3';
$string['featureoneimage'] = 'Imagen de función 1';
$string['featuretwoimage'] = 'Imagen de función 2';
$string['featurethreeimage'] = 'Imagen de función 3';
$string['featuredcourses'] = 'Cursos destacados';
$string['featuredcourseshelp'] = 'Resalte hasta 8 cursos destacados para la página principal de su sitio. Escriba el ID del curso para destacar un curso.';
$string['featuredcoursesheading'] = 'Encabezado de cursos destacados';
$string['featuredcourseone'] = 'Curso destacado 1';
$string['featuredcoursetwo'] = 'Curso destacado 2';
$string['featuredcoursethree'] = 'Curso destacado 3';
$string['featuredcoursefour'] = 'Curso destacado 4';
$string['featuredcoursefive'] = 'Curso destacado 5';
$string['featuredcoursesix'] = 'Curso destacado 6';
$string['featuredcourseseven'] = 'Curso destacado 7';
$string['featuredcourseeight'] = 'Curso destacado 8';
$string['featuredcoursesedit'] = 'Editar cursos destacados';
$string['featuredcoursesbrowseall'] = 'Explorar todos los cursos';
$string['featuredcoursesbrowsealldesc'] = 'Agregar un vínculo Explorar todos los cursos';
$string['feature_spot_background_color'] = 'Color de fondo';
$string['feature_spot_title_color'] = 'Color de texto del título';
$string['feature_spot_description_color'] = 'Color de texto de la descripción';
$string['feature_spot_title_color_lower'] = 'color de texto del título';
$string['feature_spot_description_color_lower'] = 'color de texto de la descripción';
$string['feedbackavailable'] = 'Retroalimentación disponible';
$string['feedbacktoggle'] = 'Retroalimentación y calificación';
$string['feedbacktoggledesc'] = 'Mostrar a los alumnos su retroalimentación más reciente y a los educadores las entregas más recientes que necesitan calificación.';
$string['footnote'] = 'Pie de página del sitio';
$string['footnotedesc'] = 'Puede agregar la información del sitio como HTML e incluir vínculos, imágenes o listas de eventos.';
$string['forcepwdwarningpersonalmenu'] = 'Debe <a href="{$a}">cambiar su contraseña</a> para poder usar el menú personal.';
$string['forumauthor'] = 'Autor';
$string['forumlastpost'] = 'Último mensaje';
$string['forumpicturegroup'] = 'Grupo';
$string['forumreplies'] = 'Respuestas';
$string['forumtopic'] = 'Tema';
$string['forumposts'] = 'Mensajes del foro';
$string['forumpoststoggle'] = 'Mensajes del foro';
$string['forumpoststoggledesc'] = 'Mostrar a los usuarios los 10 mensajes del foro más recientes de sus cursos.';
$string['fullname'] = 'Nombre del sitio';
$string['fullnamedesc'] = 'El nombre de su sitio.';
$string['graderadviseuserreport'] = 'El "informe del calificador" no funciona bien en dispositivos móviles. Se recomienda utilizar el "informe del usuario".';
$string['grading'] = 'Calificación';
$string['help'] = 'Ayuda';
$string['helpguide'] = 'Guía de ayuda';
$string['headingfont'] = 'Fuente del encabezado';
$string['headingfont_desc'] = 'Esta fuente (sans-serif) se usa en los encabezados (elementos H1-H6) de su sitio. Si incluye una fuente web personalizada, recuerde añadirla al formulario HTML adicional de Moodle. Si desea modificar las fuentes de otros elementos, utilice la opción de CSS personalizado. Para obtener ejemplos sobre cómo hacerlo, consulte esta <a href="https://help.openlms.net/en/administrator/manage-a-site/snap-font-family-with-custom-css/" target="_blank">documentación</a>.';
$string['helpwithlogin'] = 'Ayuda para iniciar sesión';
$string['helpwithloginandguest'] = 'Ayuda para iniciar sesión/con acceso de invitado';
$string['loginrequiredmessage'] = '* indica un campo obligatorio';
$string['hiddencoursestoggle'] = 'Cursos ocultos';
$string['highlightedsection'] = 'resaltado';
$string['home'] = 'Página de inicio';
$string['image'] = 'imagen';
$string['images'] = 'Imágenes';
$string['instagram'] = 'Instagram';
$string['instagramdesc'] = 'La URL de su cuenta de Instagram.';
$string['introduction'] = 'Introducción';
$string['jsontext'] = 'Texto JSON';
$string['jsontextdescription'] = 'El área de texto valida el JSON dado; por lo tanto, solo se permiten categorías existentes y solo los valores numéricos como registros de ID (registros de categorías) son válidos, y solo se aceptan valores hexadecimales como colores. Aquí hay un ejemplo:<br>{"1":"#FAAFFF",<br>"45":"#AFF",<br>"65":"#FFF228",<br>"12":"#CC0084",<br>"56":"#CC0087",<br>"89":"#CCF084"}';
$string['knowledgebase'] = 'Base de conocimiento de Open LMS';
$string['list'] = 'Lista';
$string['linkedin'] = 'LinkedIn';
$string['linkedindesc'] = 'La URL de la cuenta de LinkedIn de su organización.';
$string['leftnav'] = 'Tabla de contenido';
$string['leftnavdesc'] = 'Seleccione la ubicación en la que desea que aparezca la tabla de contenido. Una lista ofrece más lugar para el contenido y funciona bien en el caso de cursos con muchos temas.';
$string['loading'] = 'Cargando...';
$string['loggedinasguest'] = 'Ha iniciado sesión como invitado.';
$string['loggedoutmsg'] = 'En este momento está desconectado. Si desea continuar usando este sitio, vuelva a iniciar sesión.';
$string['loggedoutmsgtitle'] = 'Está desconectado.';
$string['loggedoutfailmsg'] = 'Debe estar conectado para {$a}.';
$string['loginform'] = 'Inicio de sesión';
$string['logo'] = 'Logo';
$string['logodesc'] = 'El logotipo se ve en el encabezado en todo el sitio.';
$string['menu'] = 'Mis cursos';
$string['messageread'] = 'Mensaje leído';
$string['messages'] = 'Mensajes';
$string['messagestoggle'] = 'Mensajes';
$string['messagestoggledesc'] = 'Muestra a los usuarios los mensajes más recientes que han recibido en las últimas 12 semanas. Para habilitar esta opción, asegúrese de que la función de mensajería de la página de características avanzadas está activada.';
$string['more'] = 'Más';
$string['morenews'] = 'Más noticias';
$string['moreoptionslabel'] = 'Más opciones';
$string['movingstartedhelp'] = 'Navegue hasta donde desea colocar la sección "{$a}"';
$string['movingdropsectionhelp'] = 'Coloque la sección "{$a->moving}" antes de la sección "{$a->before}"';
$string['moving'] = 'Moviendo "{$a}"';
$string['movingcount'] = 'Moviendo {$a} objetos';
$string['movefailed'] = 'Mover fallidos para "{$a}"';
$string['move'] = 'Mover "{$a}"';
$string['movehere'] = 'Mover aquí';
$string['movesection'] = 'Mover sección';
$string['navbarbg'] = 'Color de fondo';
$string['navbarlink'] = 'Color del texto';
$string['navbarbuttoncolor'] = 'Color de fondo';
$string['navbarbuttonlink'] = 'Color del texto';
$string['nextsection'] = 'Siguiente sección';
$string['nodeadlines'] = 'No tiene fechas límite próximas.';
$string['noforumposts'] = 'No tiene mensajes del foro relevantes.';
$string['nograded'] = 'No hay retroalimentación reciente.';
$string['nograding'] = 'No hay entregas para calificar.';
$string['nomessages'] = 'No tiene mensajes.';
$string['notanswered'] = 'Sin responder';
$string['notattempted'] = 'No intentado';
$string['notcontributed'] = 'No contribuido';
$string['notpublished'] = 'No publicado a los estudiantes';
$string['notsubmitted'] = 'No entregado';
$string['overdue'] = 'Vencida';
$string['pausegraphicsanim'] = 'Pause el GIF animado.';
$string['personalmenu'] = 'Menú personal';
$string['personalmenuandsnapfeeds'] = 'Menú personal y fuentes de Snap';
$string['personalmenufeatures'] = 'Características del menú personal';
$string['personalmenulogintoggle'] = 'Mostrar menú personal en el inicio de sesión';
$string['personalmenulogintoggledesc'] = 'Abre el menú personal inmediatamente después de iniciar sesión.';
$string['personalmenuadvancedfeedsenable'] = 'Habilitar las fuentes avanzadas';
$string['personalmenuadvancedfeedsenabledesc'] = 'Las fuentes avanzadas cargan algunos elementos del menú personal, lo que permite tiempos de carga más rápidos y actualiza el contenido bajo demanda.';
$string['personalmenuadvancedfeedsperpage'] = 'Recuento de visualización de elementos de fuentes avanzadas';
$string['personalmenuadvancedfeedsperpagedesc'] = 'Seleccione el número de elementos que desea mostrar en la fuente. Los usuarios pueden seleccionar <strong>Ver más</strong> para mostrar elementos adicionales.';
$string['personalmenuadvancedfeedslifetime'] = 'Duración de fuentes avanzadas';
$string['personalmenuadvancedfeedslifetimedesc'] = 'Elija la cantidad de tiempo que se almacenarán las fuentes en la memoria caché del navegador después del inicio de sesión. Si el valor es 0, las fuentes no se almacenarán.';
$string['personalmenurefreshdeadlines'] = 'Actualice las fechas límite usando una tarea programada.';
$string['personalmenurefreshdeadlinesdesc'] = 'Cuando la tarea se ejecute, los datos de la fecha límite se actualizarán para que los tiempos de carga de la página sean más rápidos.';
$string['personalmenuenablepersonalmenu'] = 'Habilitar el menú personal';
$string['personalmenuenablepersonalmenuheading'] = 'Menú personal';
$string['personalmenuenablepersonalmenuheadingdesc'] = 'Nota: Si el Menú personal está deshabilitado, podrá acceder a sus cursos desde la página Mis cursos. Asegúrese de que el bloque de descripción general del curso esté habilitado para que los cursos estén visibles en la página.';
$string['personalmenuenablepersonalmenudesc'] = 'El enlace Mis cursos abrirá el menú personal. Si se deshabilita, se redirigirá a la página Mis cursos.';
$string['mycoursessnapfeedsheading'] = 'Fuentes de Snap';
$string['mycoursessnapfeedsdesc'] = 'Nota: Las <strong>fuentes avanzadas</strong> solo están disponibles cuando se selecciona al menos una de las opciones <strong>Fechas límite</strong>, <strong>Retroalimentación y calificación</strong>, <strong>Mensajes</strong> o <strong>Publicaciones del foro</strong>.';
$string['refreshdeadlinestasksettingheading'] = 'Actualizar las fechas límite usando una tarea programada';
$string['pld'] = 'PLD';
$string['pluginname'] = 'Snap';
$string['poster'] = 'Imagen de tapa';
$string['posterdesc'] = 'Imagen de gran tamaño para la página principal del sitio. Las imágenes apaisadas (de 1200 x 600 píxeles) o de mayor tamaño son la mejor opción.';
$string['poweredbyrunby'] = 'Diseñado con <a href="https://{$a->subdomain}.openlms.net/" target="_blank" rel="noopener">Open LMS</a>, un producto basado en <a href="https://moodle.com/" target="_blank" rel="noopener">Moodle</a>.<br>Copyright © {$a->year} Open LMS. Todos los derechos reservados';
$string['previoussection'] = 'Sección anterior';
$string['privacy:metadata:theme_snap_course_favorites:courseid'] = 'ID del curso de preferencia del usuario';
$string['privacy:metadata:theme_snap_course_favorites:userid'] = 'ID de usuario de la persona que eligió el curso como favorito';
$string['privacy:metadata:theme_snap_course_favorites:timefavorited'] = 'Marca de tiempo que indica cuándo el usuario eligió el curso como favorito';
$string['privacy:metadata:theme_snap_course_favorites'] = 'Almacena los cursos favoritos de los usuarios para Snap';
$string['problemsfound'] = 'Problemas encontrados';
$string['progress'] = 'Progreso';
$string['readmore'] = 'Más información »';
$string['recentactivity'] = 'Actividad reciente';
$string['recentfeedback'] = 'Comentarios';
$string['region-main'] = 'Principal';
$string['region-side-main-box'] = 'Principal';
$string['region-side-post'] = 'Derecha';
$string['region-side-pre'] = 'Izquierda';
$string['region-side-top'] = 'Arriba';
$string['released'] = 'Publicado: {$a}';
$string['reopened'] = 'Reabierto';
$string['resourcedisplay'] = 'Visualización del recurso';
$string['resourcedisplayhelp'] = 'Seleccione cómo desea que aparezcan los documentos adjuntos y los enlaces en el curso. El tema Snap no admite archivos multimedia en la descripción de las tarjetas de recursos y actividades menores.';
$string['resumegraphicsanim'] = 'Reanude el GIF animado.';
$string['displaydescription'] = 'Mostrar descripción';
$string['displaydescriptionhelp'] = 'Seleccione esta opción para mostrar primero una descripción de las actividades del recurso en una página nueva. Los estudiantes podrán acceder al contenido desde la descripción.';
$string['search'] = 'Buscar contenido';
$string['showcoursegradepersonalmenu'] = 'Calificaciones';
$string['showcoursegradepersonalmenudesc'] = 'Mostrar a los usuarios su calificación en las tarjetas del curso, en el menú personal.';
$string['socialmedia'] = 'Redes sociales';
$string['submitted'] = 'Entregado';
$string['sitedescription'] = 'Descripción del sitio';
$string['subtitle'] = 'Subtítulo';
$string['subtitle_desc'] = 'Incluya una descripción breve del sitio para los usuarios.';
$string['summarylabel'] = 'Resumen de la sección';
$string['themecolor'] = 'Color del sitio';
$string['themecolordesc'] = 'Los colores brillantes son mejores y darán al sitio un aspecto moderno.';
$string['title'] = 'Título';
$string['top'] = 'Arriba';
$string['topbarbgcolor'] = 'Color de la barra de navegación';
$string['topbarlinkcolor'] = 'Color de ícono y vínculo de la barra de navegación';
$string['topbarbuttoncolor'] = 'Fondo de Mis cursos';
$string['togglenavigation'] = 'Alternar navegación';
$string['topicactions'] = 'Acciones del tema';
$string['xakatwitter'] = '𝕏';
$string['xakatwitterdesc'] = 'La URL de su cuenta de 𝕏.';
$string['unenrolme'] = 'Anular mi matriculación';
$string['enrolme'] = 'Matricularme';
$string['unread'] = 'no leídos';
$string['unsupportedcoverimagetype'] = 'Tipo de imagen de tapa no compatible ({$a})';
$string['via'] = 'a través de';
$string['viewcourse'] = 'Ver curso';
$string['viewmore'] = 'Ver más';
$string['viewyourprofile'] = 'Ver su perfil';
$string['viewmyfeedback'] = 'Ver mi retroalimentación';
$string['viewcalendar'] = 'Ver mi calendario';
$string['viewforumposts'] = 'Ver mis publicaciones de foros';
$string['viewmessaging'] = 'Ver mis mensajes';
$string['vieworiginalimage'] = 'Ver imagen original';
$string['visibility'] = 'Visibilidad';
$string['xofyanswered'] = '{$a->completed} de {$a->participants} respondidos';
$string['xofyattempted'] = '{$a->completed} de {$a->participants} intentos';
$string['xofycontributed'] = 'Se contribuyeron {$a->completed} de {$a->participants}.';
$string['xofysubmitted'] = '{$a->completed} de {$a->participants} entregados';
$string['xungraded'] = '{$a} sin calificar';
$string['youtube'] = 'YouTube';
$string['youtubedesc'] = 'La URL de su canal de YouTube.';
$string['showallsectionsdisabled'] = 'Debido al lenguaje de diseño, “Mostrar todas las secciones en una página” no está disponible en Ajustar.';
$string['disabled'] = 'Deshabilitada';
$string['showappearancedisabled'] = 'El lenguaje de diseño de Snap evita los cambios a los ajustes de "Apariencia".';
$string['pbb'] = 'Desarrollo de marca basado en el perfil';
$string['pbb_description'] = 'Si habilita la opción <strong>Personalización de la marca basada en perfiles</strong>, podrá personalizar la experiencia de personalización de la marca para un grupo específico de usuarios en función del campo de perfil de usuario elegido.<ul><li>El valor del campo de usuario <em>se convierte en una línea de texto</em>, de modo que todas las palabras se escriben en minúscula y se separan con un guion (-).</li>
<li>Se antepone la cadena <code>snap-pbb-</code></li>
<li>Esta clase se agrega a la etiqueta HTML <code>body</code></li></ul>Por ejemplo, el valor del campo de usuario <em>Blueberry Extravaganza</em> se transformará en la línea de texto <code>snap-pbb-blueberry-extravaganza</code>.<br /><br />Esta función se utiliza junto con CSS personalizado. Deberá agregar selectores CSS usando las clases nuevas en la sección <a class="snap-settings-tab-link" href="#themesnapbranding">Aspectos básicos</a>.';
$string['pbb_enable'] = 'Habilitar la opción Personalización de la marca basada en perfiles';
$string['pbb_enable_description'] = 'Solo se agrega la clase a la etiqueta body si está activa.';
$string['pbb_field'] = 'Campo del usuario que se utilizará';
$string['pbb_field_description'] = 'Este valor del campo se convertirá en una línea de texto que formará parte de una URL identificable y se utilizará como el nombre de una clase de CSS antepuesto por <code>snap-pbb-</code>.';
$string['cachedef_profile_based_branding'] = 'Almacenamiento en caché para el desarrollo de marca basado en el perfil.';
$string['cachedef_course_card_bg_image'] = 'Almacenamiento en caché para la imagen de fondo del curso.';
$string['cachedef_course_card_teacher_avatar'] = 'Almacenamiento en caché para los avatares de los profesores.';
$string['cachedef_course_card_teacher_avatar_index'] = 'Almacenamiento en caché para el índice de los avatares de los profesores.';
$string['accessforumstringdis'] = 'Opciones';
$string['accessforumstringmov'] = 'Mover opciones';
$string['accesscalendarstring'] = 'Calendario';
$string['accessglobalsearchstring'] = 'Buscar';
$string['admineventwarning'] = 'Para ver los eventos de todos los cursos,';
$string['gotocalendarsnap'] = 'diríjase al calendario del sitio.';
$string['quizattemptswarn'] = 'Excluye los intentos de los usuarios suspendidos';
$string['quizfeedback'] = 'Comentarios';
$string['validratio'] = 'Esta combinación de colores sí cumple con el valor mínimo de relación de 4.5:1 de WCAG 2.0';
$string['invalidratio'] = 'Esta combinación de colores no cumple con el <a href="https://www.w3.org/TR/WCAG20-TECHS/G18.html" target="_blank">valor mínimo de relación de 4.5:1 de WCAG 2.0</a>. Valor: "{$a}"';
$string['imageinvalidratio'] = 'Esta imagen podría presentar problemas de contraste, ya que no cumple con valor mínimo de relación de 4.5:1 de WCAG 2.0. Valor promedio de pixel: "{$a}"';
$string['catinvalidratio'] = 'Las siguientes categorías de colores no cumplen con el <a href="https://www.w3.org/TR/WCAG20-TECHS/G18.html" target="_blank">valor mínimo de relación de 4.5:1 de WCAG 2.0</a>: en contraste con el color de fondo del sitio (blanco): "{$a->white}"; en contraste con el color de fondo de la barra de navegación: "{$a->custombar}"; en contraste con el color de fondo del botón Mis cursos: "{$a->customnav}"';
$string['spotinvalidratio'] = 'El color de fondo no cumple con el <a href="https://www.w3.org/TR/WCAG20-TECHS/G18.html" target="_blank">valor mínimo de relación de 4.5:1 de WCAG 2.0</a>. Valor actual en contraste con {$a->name}: {$a->value}.';
$string['imageinvalidratiocategory'] = 'Esta imagen podría presentar problemas de contraste con el color del tema, ya que no cumple con el valor mínimo de relación de 4.5:1 de WCAG 2.0. Valor promedio de pixel: "{$a}"';
$string['lazyload_mod_page'] = 'Habilitar la carga diferida predeterminada para los recursos de página';
$string['lazyload_mod_page_description'] = 'Si se habilita esta opción, este ajuste reduce significativamente el tiempo de carga de las páginas de los cursos con muchas páginas.';
$string['pmadvancedfeed_viewmore'] = 'Ver más';
$string['pmadvancedfeed_reload'] = 'Actualizar';
$string['multimediacard'] = 'Los archivos multimedia no se mostrarán en las vistas de la tarjeta de actividades del tema Snap. Esto se aplicará en la página de inicio y en las páginas del curso solo para las tarjetas de actividades y recursos menores.';
$string['enabledlogin'] = 'Opciones de inicio de sesión visibles';
$string['enabledlogindesc'] = 'Seleccione las opciones de inicio de sesión que deberían mostrarse.';
$string['moodlelogin'] = 'Mostrar solo inicio de sesión de Moodle';
$string['alternativelogin'] = 'Mostrar solo opciones de inicio de sesión alternativas';
$string['bothlogin'] = 'Mostrar ambas opciones de inicio de sesión';
$string['enabledloginorder'] = 'Orden de las opciones de inicio de sesión';
$string['enabledloginorderdesc'] = 'Seleccione la opción de inicio de sesión que debería mostrarse primero.';
$string['moodleloginfirst'] = 'Mostrar inicio de sesión de Moodle primero';
$string['alternativeloginfirst'] = 'Mostrar opciones de inicio de sesión alternativas primero';
$string['alternativeloginoptions'] = 'Opciones de inicio de sesión alternativas';
$string['openmessagedrawer'] = 'Abra el cuadro de mensaje.';
$string['refreshdeadlinestask'] = 'Actualice los datos de la caché de las fechas límite. Esto debe ejecutarse antes de que todos los usuarios se conecten.';
$string['resetdeadlinesquerycounttask'] = 'Restablecer el recuento de consultas de plazos';
$string['refreshdeadlinestaskoff'] = 'No se han buscado datos para introducir. Active el ajuste "Actualizar fechas límite utilizando tareas programadas" en la configuración del menú Personal de Snap para permitir a esta tarea introducir los datos de fechas límite en caché.';
$string['activityrestriction'] = 'Restricción de actividad';
$string['hideandshowactioncb'] = 'Ocultar y mostrar acción de casilla de verificación de actividad';
$string['retryfeed'] = 'Esta fuente no está disponible en este momento. Vuelva a intentarlo más tarde. Fuente: {$a}';
$string['loadingfeed'] = 'Cargando... puede llevar tiempo';
$string['hvpcustomcss'] = 'CSS personalizado de H5P';
$string['hvpcustomcssdesc'] = 'CSS personalizado para el módulo H5P (moodle.org/plugins/mod_hvp) si está instalado.';
$string['courselimitstrdanger'] = 'La barra de progreso del límite del curso alcanzado no se mostrará.';
$string['courselimitstrwarning'] = 'Si se enumeran más de {$a} cursos, no se mostrará la barra de progreso';
$string['tilesformatcoursehomealttext'] = 'Página de inicio del curso';
$string['editmodetiles'] = 'Editar contenidos';
$string['totop'] = 'Ir arriba';
$string['loginsetting'] = 'Página de inicio de sesión';
$string['loginbgimgheading'] = 'Plantilla de página de inicio de sesión';
$string['loginbgimgheadingdesc'] = 'Snap permite cambiar entre las diferentes plantillas que se muestran en la página de inicio de sesión. Seleccione entre las diferentes opciones del menú desplegable que aparece a continuación.';
$string['loginpagetemplate'] = 'Seleccione la plantilla de página de inicio de sesión que se debe utilizar';
$string['classic_template'] = 'Plantilla clásica';
$string['loginbgimg'] = 'Imagen de fondo de pantalla de inicio de sesión';
$string['loginbgimgdesc'] = 'Seleccione las imágenes que aparecerán en el fondo de la página de inicio de sesión. Para disfrutar de una mejor experiencia con las imágenes mostradas, cargue archivos con una relación de aspecto de 16:9 (resolución de 720p o dimensiones de 1280 x 720 píxeles). Las imágenes cargadas deben tener las mismas dimensiones para una visualización correcta.';
$string['stylish_template'] = 'Plantilla elegante';
$string['activityedit'] = 'Editar actividad';
$string['snapfeedsblocktitle'] = 'Fuentes de Snap';
$string['tiktok'] = 'TikTok';
$string['tiktokdesc'] = 'La URL de su cuenta de TikTok.';
$string['snapfootersettings'] = 'Pie de página de Snap';
$string['snapfootercustomization'] = 'Personalización del pie de página';
$string['snapfootercustomizationdesc'] = 'Snap permite personalizar el pie de página del tema, que se muestra en todo el sitio. Mejore la experiencia del usuario agregando enlaces útiles, recursos de asistencia o cualquier otra información valiosa sobre su organización que desee compartir con estudiantes y profesores.';
$string['snapfootercolors'] = 'Colores del pie de página del sitio';
$string['snapfootercolorsdesc'] = 'Los colores del pie de página se pueden cambiar: para modificar el color de fondo o del texto, selecciónelos en los siguientes selectores de color.';
$string['snapfooterbgcolor'] = 'Color de fondo del pie de página';
$string['snapfootertxtcolor'] = 'Color del texto del pie de página';
$string['enableblockmyoverviewwarning'] = 'El bloque de descripción general del curso está deshabilitado. Para mostrar los cursos, habilítelo.';
$string['collapseicon'] = 'Contraer el contenido de';
$string['expandicon'] = 'Expandir el contenido de';
