<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @copyright  Copyright (c) 2024 Open LMS (https://www.openlms.net)
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutcourse'] = 'O tym kursie';
$string['activity'] = 'Aktywność';
$string['action:changeassetvisibility'] = 'zmień widoczność zasobu';
$string['action:duplicateasset'] = 'duplikuj zasób';
$string['action:changesectionvisibility'] = 'zmień widoczność sekcji';
$string['action:highlightsectionvisibility'] = 'wyróżnij widoczność sekcji';
$string['action:sectiontoc'] = 'pobierz spis treści sekcji';
$string['addanewsection'] = 'Utwórz nową sekcję';
$string['addresourceoractivity'] = 'Dodaj aktywność związaną z nauczaniem';
$string['admin'] = 'Administracja';
$string['advancedbrandingheading'] = 'Zaawansowane oznakowanie';
$string['ago'] = 'temu';
$string['answered'] = 'Udzielone odpowiedzi';
$string['appendices'] = 'Narzędzia';
$string['arialabelnewsarticle'] = 'artykuł z wiadomościami';
$string['assigndraft'] = 'Wersja robocza wymaga potwierdzenia';
$string['assignreopened'] = 'Ponownie otwarte';
$string['at'] = 'o';
$string['attempted'] = 'Podjęto próbę';
$string['basics'] = 'Ustawienia podstawowe';
$string['brandingheading'] = 'Oznakowanie';
$string['browse'] = 'Przeglądaj';
$string['browseallcourses'] = 'Przeglądaj wszystkie kursy';
$string['cachedef_activity_deadlines'] = 'Magazyn pamięci podręcznej na terminy aktywności użytkowników.';
$string['cachedef_generalstaticappcache'] = 'Wykonaj migawkę ogólnej statycznej pamięci podręcznej na poziomie aplikacji';
$string['cachedef_course_completion_progress'] = 'Służy do buforowania danych na temat ukończenia dotyczących kursu lub użytkownika.';
$string['cachedef_course_completion_progress_ts'] = 'Służy do unieważniania pamięci podręcznych na poziomie sesji w przypadku zmiany ustawień ukończenia kursu dotyczących kursu lub modułu.';
$string['cachedef_webservicedefinitions'] = 'Buforowanie automatycznie generowanych definicji usług sieciowych.';
$string['card'] = 'Karta';
$string['categoryedit'] = 'Edytuj kategorię';
$string['category_color'] = 'Kolor kategorii';
$string['category_color_description'] = 'Kolor kategorii kursu. Kursy podrzędne korzystają z konfiguracji najbliższej kategorii nadrzędnej';
$string['category_color_palette'] = 'Paleta kolorów';
$string['category_color_palette_description'] = 'Zobacz wartość szesnastkową odpowiadającą danemu kolorowi. Nie wpłynie to na żadną konfigurację. Jest to tylko próbka ułatwiająca użytkownikom tworzenie wartości konfiguracji.';
$string['changecoverimage'] = 'Zmień obraz na pierwszą stronę';
$string['changefullname'] = 'Zmień nazwę witryny';
$string['chapters'] = 'Rozdziały';
$string['choosereadme'] = '<div class="clearfix"><div class="theme_screenshot"><h2>Snap</h2><img class=img-polaroid src="snap/pix/screenshot.jpg" /></div></div>';
$string['close'] = 'Zamknij';
$string['conditional'] = 'Warunkowo';
$string['contents'] = 'Zawartość';
$string['contributed'] = 'Współtwórca';
$string['courses'] = 'Kursy';
$string['coursecontacts'] = 'Kontakty kursu';
$string['coursedisplay'] = 'Wyświetlanie kursu';
$string['coursefootertoggle'] = 'Stopka kursu';
$string['coursefootertoggledesc'] = 'W stopce na stronie kursu wyświetlane są informacje przydatne dla użytkowników, w tym kontakty kursu, opis kursu i ostatnia aktywność na kursie.';
$string['courseformatnotification'] = 'Aktualnie używany format kursu nie jest w pełni obsługiwany przez motyw Snap. W celu uzyskania najlepszych rezultatów Open LMS zaleca stosowanie z motywem Snap formatów kursu Tematy lub Tygodniowy. Format kursu można zmienić w <a href="{$a}">ustawieniach kursu</a>.';
$string['coursefixydefaulttext'] = 'Nie uczestniczysz obecnie w żadnym kursie.<br>Kursy, w których uczestniczysz, będą wyświetlone tutaj.';
$string['coursegrade'] = 'Ocena z kursu:';
$string['coursepartialrender'] = 'Włącz ładowanie opóźnione dla sekcji kursu';
$string['coursepartialrenderdesc'] = 'Jeśli ta opcja jest włączona, sekcje kursu są ładowane na żądanie po wybraniu przez użytkownika. Pozwala to szybciej ładować kursy zawierające duże ilości danych.';
$string['coursenavigation'] = 'Nawigacja kursu';
$string['coursesummaryfilesunsuitable'] = 'Opróżnij pliki podsumowania kursu, zanim podejmiesz próbę zmiany obrazu na pierwszą stronę';
$string['courseactionslabel'] = 'czynności';
$string['courseactivitieslabel'] = 'Działania w ramach sekcji';
$string['coursetools'] = 'Pulpit kursu';
$string['coverdisplay'] = 'Wyświetlanie pierwszej strony';
$string['covercarousel'] = 'Obraz przewijany na pierwszą stronę';
$string['covercarousellabel'] = 'Karuzela';
$string['covercarouselon'] = 'Użyj obrazu przewijanego na pierwszej stronie';
$string['covercarouseldescription'] = '<p>Obraz przewijany to zestaw przewijanych banerów albo pokaz slajdów, który jest wyświetlany na stronie głównej witryny zamiast obrazu tytułowego.</p>
<p>Można dodać maksymalnie trzy obrazy, tytuł każdego slajdu oraz opcjonalny podtytuł. Najlepiej wyglądają obrazy o wielkości 1200 × 600 pikseli.</p>';
$string['covercarouselsronly'] = 'Jest to obraz przewijany z automatycznie przewijającymi się slajdami. Aktywuj dowolny z przycisków, aby wyłączyć przewijanie. Użyj przycisków Dalej i Wstecz, aby nawigować, lub przeskakuj do kolejnych slajdów za pomocą kropek.';
$string['covercarouselplaybutton'] = 'Wznów automatyczne przewijanie slajdów dla tego obrazu przewijanego.';
$string['covercarouselpausebutton'] = 'Wstrzymaj automatyczne przewijanie slajdów dla tego obrazu przewijanego.';
$string['coverimage'] = 'Obraz na pierwszą stronę';
$string['covervideo'] = 'Film tytułowy';
$string['comingsoon'] = 'Już wkrótce!';
$string['createsection'] = 'Utwórz sekcję';
$string['current'] = 'Bieżąca';
$string['customcss'] = 'Niestandardowe reguły CSS';
$string['customcssdesc'] = 'Należy pamiętać, że duże możliwości wiążą się z poważną odpowiedzialnością. Wszelkie problemy spowodowane przez arkusz CSS dodany w tym miejscu trzeba rozwiązywać we własnym zakresie. Dział pomocy technicznej Open LMS nie zajmuje się rozwiązywaniem problemów wynikających z użycia arkuszy CSS ani nie pomaga w ich rozwiązywaniu.';
$string['customtopbar'] = 'Pasek nawigacji';
$string['customisenavbar'] = 'Zmień kolory paska nawigacyjnego';
$string['customisenavbutton'] = 'Zmień kolory przycisków Moje kursy';
$string['customisecustommenu'] = 'Zmień niestandardowy kolor tekstu menu';
$string['custommenutext'] = 'Niestandardowy kolor tekstu menu';
$string['deadlines'] = 'Terminy końcowe';
$string['deadlinestoggle'] = 'Terminy końcowe';
$string['deadlinestoggledesc'] = 'Pokazuj użytkownikom zbliżające się terminy realizacji aktywności w ramach kursów, na które są zapisani.';
$string['defaultsummary'] = 'W obszarze tym opisz temat - użyj tekstu, obrazów oraz materiałów audio i wideo.';
$string['defaultintrosummary'] = 'Witamy w Twoim nowym kursie {$a}.<br>Zacznij od opisania tematu kursu, używając tekstu, obrazów oraz materiałów audio i wideo.';
$string['defaulttopictitle'] = 'Temat bez tytułu';
$string['debugerrors'] = 'Błędy debugowania';
$string['deleteassetconfirm'] = 'Usuń {$a}';
$string['deletingasset'] = 'Usuwanie {$a}';
$string['deletingassetname'] = 'Usuwanie zasobu {$a->type} „{$a->name}”';
$string['deletesectionconfirm'] = 'Usuń sekcję';
$string['deletingsection'] = 'Usuwanie sekcji „{$a}”';
$string['draft'] = 'Nie ujawniane studentom';
$string['dropzonelabel'] = 'Upuść pliki do dołączenia lub <span class="fake-link">przeglądaj</span>';
$string['due'] = 'Termin {$a}';
$string['edit'] = 'Edytuj „{$a}”';
$string['editcoursecontent'] = 'Edytuj bloki';
$string['editcoursesettings'] = 'Ustawienia kursu';
$string['editcoursetopic'] = 'Edytuj sekcję';
$string['editcustomfooter'] = 'Edytuj stopkę';
$string['editcustommenu'] = 'Edytuj menu niestandardowe';
$string['error'] = 'Błąd';
$string['errorgettingfeed'] = 'Wystąpił błąd podczas pobierania elementów kanału.';
$string['error:categorycolorinvalidjson'] = 'Niepoprawny format JSON dla kategorii kursu';
$string['error:categorycolorinvalidvalue'] = 'Nieprawidłowy identyfikator rekordu lub wartość koloru dla kategorii „{$a}”';
$string['error:categorynotfound'] = 'Nie znaleziono rekordu kategorii o identyfikatorze „{$a}”';
$string['error:coverimageexceedsmaxbytes'] = 'Plik obrazu na pierwszą stronę przekracza maksymalną dozwoloną wielkość na poziomie witryny ({$a})';
$string['error:coverimageresolutionlow'] = 'Aby uzyskać najlepszą jakość, zalecamy użycie większego obrazu o szerokości co najmniej 1024px.';
$string['error:duplicatedcategoryids'] = 'Niepoprawny format JSON, niektóre identyfikatory są zduplikowane';
$string['error:failedtochangeassetvisibility'] = 'Nie udało się ukryć/wyświetlić zasobu';
$string['error:failedtochangesectionvisibility'] = 'Nie udało się ukryć/wyświetlić sekcji';
$string['error:failedtohighlightsection'] = 'Nie udało się wyróżnić sekcji';
$string['error:failedtoduplicateasset'] = 'Nie udało się zduplikować';
$string['error:failedtodeleteasset'] = 'Nie udało się usunąć zasobu';
$string['error:failedtotoc'] = 'Niepowodzenie pobrania spisu treści.';
$string['extension'] = 'Rozszerzenie {$a}';
$string['facebook'] = 'Facebook';
$string['facebookdesc'] = 'Adres URL Twojej strony na Facebooku.';
$string['favicon'] = 'Ikona favicon';
$string['favicondesc'] = 'Ikona favicon jest wyświetlana w pasku adresu przeglądarki internetowej, w zakładkach użytkownika oraz jako skrót na urządzeniu mobilnym.';
$string['favorite'] = 'Ulubione {$a}';
$string['favorited'] = 'Dodano do ulubionych {$a}';
$string['featurespots'] = 'Wyróżnione elementy';
$string['featurespotsedit'] = 'Edytuj wyróżnione elementy';
$string['featurespotshelp'] = '<p>Dodaj do strony głównej witryny maksymalnie trzy wyróżnione elementy, aby wypunktować najważniejsze korzyści dla bieżących i potencjalnych użytkowników.</p>
<p>Do każdej funkcji można dodać obraz, tytuł i opis zawartości. Aby wyświetlić tę funkcję na pierwszej stronie, należy wprowadzić tytuł. Sekcje obrazu i opisu zawartości są opcjonalne.</p>
<p>Zalecany rozmiar obrazu to kwadrat nie większy niż 200 pikseli na 200 pikseli.</p>';
$string['featurespotsheading'] = 'Nagłówek wyróżnionych elementów';
$string['featureonetitle'] = 'Tytuł elementu nr 1';
$string['featuretwotitle'] = 'Tytuł elementu nr 2';
$string['featurethreetitle'] = 'Tytuł elementu nr 3';
$string['featureonetitlelink'] = 'Łącze do tytułu elementu nr 1';
$string['featuretwotitlelink'] = 'Łącze do tytułu elementu nr 2';
$string['featurethreetitlelink'] = 'Łącze do tytułu elementu nr 3';
$string['featuretitlelinkdesc'] = 'Wpisz adres URL, z którym chcesz połączyć ten wyróżniony element. Możesz dodawać linki wewnętrzne lub zewnętrzne w obrębie witryny. Aby dodać link wewnętrzny, skopiuj go z adresu URL witryny po znaku /. Aby na przykład mieć link do kursu, musiałby on mieć postać „kurs/view.php?id=160”. Aby dodać link zewnętrzny, zacznij go od ciągu znaków https://';
$string['featureonetitlecb'] = 'Element nr 1 otwierany w nowym oknie';
$string['featuretwotitlecb'] = 'Element nr 2 otwierany w nowym oknie';
$string['featurethreetitlecb'] = 'Element nr 3 otwierany w nowym oknie';
$string['featuretitlecbdesc'] = 'Jeśli ta opcja jest włączona, łącze dodane do wyróżnionego elementu będzie otwierane w nowym oknie';
$string['featureonetext'] = 'Zawartość elementu nr 1';
$string['featuretwotext'] = 'Zawartość elementu nr 2';
$string['featurethreetext'] = 'Zawartość elementu nr 3';
$string['featureoneimage'] = 'Obraz elementu nr 1';
$string['featuretwoimage'] = 'Obraz elementu nr 2';
$string['featurethreeimage'] = 'Obraz elementu nr 3';
$string['featuredcourses'] = 'Wyróżnione kursy';
$string['featuredcourseshelp'] = 'Wyróżnij na stronie głównej witryny maksymalnie osiem kursów. Wpisz identyfikator kursu, który chcesz wyróżnić.';
$string['featuredcoursesheading'] = 'Nagłówek wyróżnionych kursów';
$string['featuredcourseone'] = 'Wyróżniony kurs nr 1';
$string['featuredcoursetwo'] = 'Wyróżniony kurs nr 2';
$string['featuredcoursethree'] = 'Wyróżniony kurs nr 3';
$string['featuredcoursefour'] = 'Wyróżniony kurs nr 4';
$string['featuredcoursefive'] = 'Wyróżniony kurs nr 5';
$string['featuredcoursesix'] = 'Wyróżniony kurs nr 6';
$string['featuredcourseseven'] = 'Wyróżniony kurs nr 7';
$string['featuredcourseeight'] = 'Wyróżniony kurs nr 8';
$string['featuredcoursesedit'] = 'Edytuj wyróżnione kursy';
$string['featuredcoursesbrowseall'] = 'Przeglądaj wszystkie kursy';
$string['featuredcoursesbrowsealldesc'] = 'Dodaj łącze do przeglądania wszystkich kursów';
$string['feature_spot_background_color'] = 'Kolor tła';
$string['feature_spot_title_color'] = 'Kolor tekstu tytułu';
$string['feature_spot_description_color'] = 'Kolor tekstu opisu';
$string['feature_spot_title_color_lower'] = 'kolor tekstu tytułu';
$string['feature_spot_description_color_lower'] = 'kolor tekstu opisu';
$string['feedbackavailable'] = 'Dostępny jest komunikat zwrotny';
$string['feedbacktoggle'] = 'Komunikaty zwrotne i oceny';
$string['feedbacktoggledesc'] = 'Pokazuj uczniom najnowsze komunikaty zwrotne, a nauczycielom ostatnio złożone prace, które oczekują na ocenę.';
$string['footnote'] = 'Stopka witryny';
$string['footnotedesc'] = 'Informacje o witrynie można dodawać w formacie HTML i dołączać do nich łącza, obrazy lub listy zdarzeń.';
$string['forcepwdwarningpersonalmenu'] = 'Musisz <a href="{$a}">zmienić hasło</a>, aby używać menu osobistego.';
$string['forumauthor'] = 'Autor';
$string['forumlastpost'] = 'Ostatni wpis';
$string['forumpicturegroup'] = 'Grupa';
$string['forumreplies'] = 'Odpowiedzi';
$string['forumtopic'] = 'Temat';
$string['forumposts'] = 'Wpisy forum';
$string['forumpoststoggle'] = 'Wpisy forum';
$string['forumpoststoggledesc'] = 'Pokazuj użytkownikom 10 najnowszych wpisów na forum z ich kursów.';
$string['fullname'] = 'Nazwa witryny';
$string['fullnamedesc'] = 'Nazwa używanej witryny.';
$string['graderadviseuserreport'] = 'Funkcja „Dziennik ocen” może nie działać prawidłowo na urządzeniach mobilnych. Zaleca się korzystać z funkcji „Moje oceny”.';
$string['grading'] = 'Ocenianie';
$string['help'] = 'Pomoc';
$string['helpguide'] = 'Podręcznik pomocy';
$string['headingfont'] = 'Czcionka nagłówka';
$string['headingfont_desc'] = 'Ta czcionka sans-serif jest używana w nagłówkach (elementy h1–h6) w całej witrynie. Jeśli dołączasz niestandardową czcionkę internetową, pamiętaj, aby dodać ją do dodatkowego Moodle HTML. Jeśli chcesz zmodyfikować czcionki innych elementów, skorzystaj z opcji Niestandardowe CSS. Przykłady znajdziesz w tej <a href="https://help.openlms.net/en/administrator/manage-a-site/snap-font-family-with-custom-css/" target="_blank">dokumentacji</a>.';
$string['helpwithlogin'] = 'Pomoc w logowaniu';
$string['helpwithloginandguest'] = 'Pomoc w logowaniu / uzyskiwaniu dostępu gościa';
$string['loginrequiredmessage'] = '* wskazuje, że dane pole jest polem wymaganym';
$string['hiddencoursestoggle'] = 'Ukryte kursy';
$string['highlightedsection'] = 'podświetlone';
$string['home'] = 'strona główna';
$string['image'] = 'obraz';
$string['images'] = 'Obrazy';
$string['instagram'] = 'Instagram';
$string['instagramdesc'] = 'Adres URL konta na Instagramie.';
$string['introduction'] = 'Wprowadzenie';
$string['jsontext'] = 'Tekst JSON';
$string['jsontextdescription'] = 'Obszar tekstowy weryfikuje dany kod JSON, dlatego dozwolone są tylko istniejące kategorie, prawidłowe są tylko liczbowe wartości identyfikatorów rekordów (rekordów kategorii), a jako kolory akceptowane są tylko wartości szesnastkowe. Przykład:<br>{"1":"#FAAFFF",<br>"45":"#AFF",<br>"65":"#FFF228",<br>"12":"#CC0084",<br>"56":"#CC0087",<br>"89":"#CCF084"}';
$string['knowledgebase'] = 'Baza wiedzy Open LMS';
$string['list'] = 'Lista';
$string['linkedin'] = 'LinkedIn';
$string['linkedindesc'] = 'Adres URL Twojej organizacji w LinkedIn.';
$string['leftnav'] = 'Spis treści';
$string['leftnavdesc'] = 'Wybierz miejsce wyświetlania spisu treści. Lista daje więcej miejsca na treść i sprawdza się w przypadku kursów z wieloma tematami.';
$string['loading'] = 'Ładuję ...';
$string['loggedinasguest'] = 'Jesteś zalogowany(a) jako gość';
$string['loggedoutmsg'] = 'Użytkownik jest obecnie wylogowany. Jeśli chcesz kontynuować korzystanie z tej witryny, zaloguj się ponownie.';
$string['loggedoutmsgtitle'] = 'Użytkownik jest wylogowany';
$string['loggedoutfailmsg'] = 'Użytkownik musi być zalogowany do {$a}.';
$string['loginform'] = 'Zaloguj się';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Logo jest wyświetlane w nagłówku w całej witrynie.';
$string['menu'] = 'Moje kursy';
$string['messageread'] = 'Wiadomość przeczytana';
$string['messages'] = 'Wiadomości';
$string['messagestoggle'] = 'Wiadomości';
$string['messagestoggledesc'] = 'Pokaż użytkownikom najnowsze wiadomości otrzymane w ciągu ostatnich 12 tygodni. Aby włączyć tę opcję, upewnij się, że funkcja wiadomości na stronie Zaawansowane funkcje jest włączona.';
$string['more'] = 'Więcej';
$string['morenews'] = 'Więcej wiadomości';
$string['moreoptionslabel'] = 'Więcej opcji';
$string['movingstartedhelp'] = 'Przejdź do miejsca, w którym chcesz umieścić sekcję „{$a}”';
$string['movingdropsectionhelp'] = 'Umieść sekcję „{$a->moving}” przed sekcją „{$a->before}”';
$string['moving'] = 'Przenoszenie „{$a}”';
$string['movingcount'] = 'Przenoszenie {$a} obiektów';
$string['movefailed'] = 'Niepowodzenie przenoszenia dla „{$a}”';
$string['move'] = 'Przenieś „{$a}”';
$string['movehere'] = 'Przenieś tutaj';
$string['movesection'] = 'Przenieś sekcję';
$string['navbarbg'] = 'Kolor tła';
$string['navbarlink'] = 'Kolor tekstu';
$string['navbarbuttoncolor'] = 'Kolor tła';
$string['navbarbuttonlink'] = 'Kolor tekstu';
$string['nextsection'] = 'Następna sekcja';
$string['nodeadlines'] = 'Nie masz zbliżających się terminów.';
$string['noforumposts'] = 'Brak odpowiednich wpisów na forum.';
$string['nograded'] = 'Nie masz najnowszych komunikatów zwrotnych.';
$string['nograding'] = 'Nie masz złożonych prac do oceny.';
$string['nomessages'] = 'Nie masz żadnych wiadomości.';
$string['notanswered'] = 'Nie udzielono odpowiedzi';
$string['notattempted'] = 'Nie próbowano';
$string['notcontributed'] = 'Bez wkładu';
$string['notpublished'] = 'Nie ujawniane studentom';
$string['notsubmitted'] = 'Nieprzesłane';
$string['overdue'] = 'Zaległy';
$string['pausegraphicsanim'] = 'Wstrzymaj animację GIF.';
$string['personalmenu'] = 'Menu osobiste';
$string['personalmenuandsnapfeeds'] = 'Menu osobiste i kanały Snap';
$string['personalmenufeatures'] = 'Funkcje menu osobistego';
$string['personalmenulogintoggle'] = 'Pokaż menu osobiste podczas logowania';
$string['personalmenulogintoggledesc'] = 'Otwiera menu osobiste natychmiast po zalogowaniu.';
$string['personalmenuadvancedfeedsenable'] = 'Włącz zaawansowane strumienie';
$string['personalmenuadvancedfeedsenabledesc'] = 'Zaawansowane źródła ładują osobiste elementy menu, które umożliwiają szybsze ładowanie i odświeżania treści na żądanie.';
$string['personalmenuadvancedfeedsperpage'] = 'Liczba wyświetlanych elementów zaawansowanego źródła';
$string['personalmenuadvancedfeedsperpagedesc'] = 'Wybierz liczbę elementów wyświetlanych w źródle. Użytkownicy mogą wybrać opcję <strong>Zobacz więcej</strong>, aby wyświetlić dodatkowe elementy.';
$string['personalmenuadvancedfeedslifetime'] = 'Żywotność zaawansowanego kanału';
$string['personalmenuadvancedfeedslifetimedesc'] = 'Wybierz, jak długo kanały będą buforowane w przeglądarce po zalogowaniu. Ustawienie wartości na 0 nie spowoduje buforowania kanałów w przeglądarce.';
$string['personalmenurefreshdeadlines'] = 'Odświeżaj terminy za pomocą zaplanowanego zadania.';
$string['personalmenurefreshdeadlinesdesc'] = 'Kiedy zadanie zostanie uruchomione, dane o terminach będą odświeżane w celu skrócenia czasu ładowania strony.';
$string['personalmenuenablepersonalmenu'] = 'Włącz menu osobiste';
$string['personalmenuenablepersonalmenuheading'] = 'Menu osobiste';
$string['personalmenuenablepersonalmenuheadingdesc'] = 'Uwaga: Jeśli menu osobiste jest wyłączone, dostęp do kursów można uzyskać ze strony Moje kursy. Upewnij się, że blok przeglądu kursu jest włączony, aby kursy były widoczne na stronie.';
$string['personalmenuenablepersonalmenudesc'] = 'Łącze Moje kursy otworzy menu osobiste. Jeśli ta opcja jest wyłączona, nastąpi przekierowanie do strony Moje kursy.';
$string['mycoursessnapfeedsheading'] = 'Kanały Snap';
$string['mycoursessnapfeedsdesc'] = 'Uwaga: <strong>Kanały zaawansowane</strong> są dostępne tylko wtedy, gdy wybrano co najmniej jedną z opcji: <strong>Terminy</strong>, <strong>Komentarze i oceny</strong>, <strong>Wiadomości</strong> lub <strong>Posty na forum</strong>.';
$string['refreshdeadlinestasksettingheading'] = 'Odświeżaj terminy za pomocą zaplanowanego zadania';
$string['pld'] = 'PLD';
$string['pluginname'] = 'Snap';
$string['poster'] = 'Obraz na pierwszą stronę';
$string['posterdesc'] = 'Duży obraz nagłówka wyświetlany na stronie głównej witryny. Najlepiej wyglądają obrazy w orientacji poziomej 1200 na 600 pikseli lub większe.';
$string['poweredbyrunby'] = 'Utworzono za pomocą <a href="https://{$a->subdomain}.openlms.net/" target="_blank" rel="noopener">Open LMS</a>, produktu opartego na platformie <a href="https://moodle.com/" target="_blank" rel="noopener">Moodle</a>.<br>Copyright © {$a->year} Open LMS, Wszelkie prawa zastrzeżone.';
$string['previoussection'] = 'Poprzednia sekcja';
$string['privacy:metadata:theme_snap_course_favorites:courseid'] = 'Identyfikator kursu, który użytkownik oznaczył jako ulubiony';
$string['privacy:metadata:theme_snap_course_favorites:userid'] = 'Identyfikator użytkownika, który oznaczył kurs jako ulubiony';
$string['privacy:metadata:theme_snap_course_favorites:timefavorited'] = 'Znacznik czasu oznaczenia przez użytkownika kursu jako ulubiony';
$string['privacy:metadata:theme_snap_course_favorites'] = 'Przechowuje ulubione kursy użytkownika na potrzeby Snap';
$string['problemsfound'] = 'Wykryto błędy';
$string['progress'] = 'Progress';
$string['readmore'] = 'Czytaj więcej »';
$string['recentactivity'] = 'Bieżąca aktywność';
$string['recentfeedback'] = 'Opinie zwrotne';
$string['region-main'] = 'Główny';
$string['region-side-main-box'] = 'Główny';
$string['region-side-post'] = 'prawo';
$string['region-side-pre'] = 'lewo';
$string['region-side-top'] = 'Górny';
$string['released'] = 'Wydanie: {$a}';
$string['reopened'] = 'Ponownie otwarte';
$string['resourcedisplay'] = 'Wyświetlanie zasobu';
$string['resourcedisplayhelp'] = 'Wybierz sposób wyświetlania załączników i łączy w kursie. Kompozycja Snap nie obsługuje plików multimedialnych w opisie małych kart aktywności i zasobów.';
$string['resumegraphicsanim'] = 'Wznów animację GIF.';
$string['displaydescription'] = 'Wyświetl opis';
$string['displaydescriptionhelp'] = 'Wybierz tę opcję, aby najpierw wyświetlić opis działań dotyczących zasobów na nowej stronie. Studenci uzyskają dostęp do treści z opisu.';
$string['search'] = 'Przeszukaj zawartość';
$string['showcoursegradepersonalmenu'] = 'Oceny';
$string['showcoursegradepersonalmenudesc'] = 'Pokazuj użytkownikom ich oceny na kartach kursu w menu osobistym';
$string['socialmedia'] = 'Media społecznościowe';
$string['submitted'] = 'Przesłane';
$string['sitedescription'] = 'Opis witryny';
$string['subtitle'] = 'Podtytuł';
$string['subtitle_desc'] = 'Opisz w skrócie swoją witrynę dla użytkowników.';
$string['summarylabel'] = 'Podsumowanie sekcji';
$string['themecolor'] = 'Kolor witryny';
$string['themecolordesc'] = 'Jaskrawe kolory są najlepsze i nadają witrynie nowoczesny wygląd.';
$string['title'] = 'Tytuł';
$string['top'] = 'Górny';
$string['topbarbgcolor'] = 'Kolor paska nawigacyjnego';
$string['topbarlinkcolor'] = 'Kolor łącza i ikony paska nawigacyjnego';
$string['topbarbuttoncolor'] = 'Tło moich kursów';
$string['togglenavigation'] = 'Przełącz nawigację';
$string['topicactions'] = 'Akcje na tematach';
$string['xakatwitter'] = '𝕏';
$string['xakatwitterdesc'] = 'Adres URL Twojego konta w serwisie 𝕏.';
$string['unenrolme'] = 'Wypisz mnie';
$string['enrolme'] = 'Zapisz mnie';
$string['unread'] = 'nieprzeczytane';
$string['unsupportedcoverimagetype'] = 'Nieobsługiwany typ obrazu na pierwszą stronę ({$a})!';
$string['via'] = 'za pomocą';
$string['viewcourse'] = 'Wyświetl kurs';
$string['viewmore'] = 'Zobacz więcej';
$string['viewyourprofile'] = 'Wyświetl swój profil';
$string['viewmyfeedback'] = 'Wyświetl moje informacje zwrotne';
$string['viewcalendar'] = 'Wyświetl mój kalendarz';
$string['viewforumposts'] = 'Wyświetl moje wpisy na forum';
$string['viewmessaging'] = 'Wyświetl moje wiadomości';
$string['vieworiginalimage'] = 'Wyświetl oryginalny obraz';
$string['visibility'] = 'Widoczność';
$string['xofyanswered'] = 'Udzielono odpowiedzi: {$a->completed} z {$a->participants}';
$string['xofyattempted'] = 'Podejścia: {$a->completed} z {$a->participants}';
$string['xofycontributed'] = 'Udział {$a->completed} z {$a->participants}';
$string['xofysubmitted'] = 'Złożone: {$a->completed} z {$a->participants}';
$string['xungraded'] = 'Nie ocenione: {$a}';
$string['youtube'] = 'YouTube';
$string['youtubedesc'] = 'Adres URL Twojego kanału na YouTube.';
$string['showallsectionsdisabled'] = 'Ze względu na język projektu opcja „Pokaż wszystkie sekcje na jednej stronie” jest niedostępna w trybie Snap.';
$string['disabled'] = 'Nieaktywny';
$string['showappearancedisabled'] = 'Język projektu usługi Snap uniemożliwia wprowadzanie zmian w ustawieniach „Wygląd”.';
$string['pbb'] = 'Oznakowanie na podstawie profilu';
$string['pbb_description'] = 'Włączenie opcji <strong>Oznakowanie na podstawie profilu</strong> umożliwia dostosowanie oznakowania pod kątem określonej grupy użytkowników na podstawie wybranego pola profilu użytkownika.<ul><li>Wartość pola użytkownika stanie się <em>slugified</em>; przez zastąpienie wszystkich wielkich liter małymi, a znaków odstępu myślnikami (-)</li>
<li>Na początku zostanie dopisany ciąg <code>snap-pbb-</code></li>
<li>Ta klasa zostanie dodana do znacznika <code>body</code> html</li></ul>Przykładowo wartość pola użytkownika <em>Blueberry Extravaganza</em> zostanie przekształcona na <code>snap-pbb-blueberry-extravaganza</code><br /><br />Ta funkcja jest używana w połączeniu z niestandardowym arkuszem stylów CSS. Selektory CSS należy dodać przy użyciu nowych klas w sekcji <a class="snap-settings-tab-link" href="#themesnapbranding">Basics</a>.';
$string['pbb_enable'] = 'Włącz oznakowanie na podstawie profilu';
$string['pbb_enable_description'] = 'Dodaje klasę do znacznika body tylko, jeśli aktywne.';
$string['pbb_field'] = 'Pole użytkownika do użycia';
$string['pbb_field_description'] = 'Wartość tego pola zostanie przekształcona w ciąg znaków bez spacji i użyta jako nazwa klasy CSS z przedrostkiem <code>snap-pbb-</code>.';
$string['cachedef_profile_based_branding'] = 'Buforowanie na potrzeby oznakowania na podstawie profilu.';
$string['cachedef_course_card_bg_image'] = 'Buforowanie obrazu tła kursu.';
$string['cachedef_course_card_teacher_avatar'] = 'Buforowanie awatarów nauczycieli.';
$string['cachedef_course_card_teacher_avatar_index'] = 'Buforowanie indeksu awatarów nauczycieli.';
$string['accessforumstringdis'] = 'Opcje';
$string['accessforumstringmov'] = 'Opcje przenoszenia';
$string['accesscalendarstring'] = 'Kalendarz';
$string['accessglobalsearchstring'] = 'Wyszukaj';
$string['admineventwarning'] = 'Aby wyświetlić wydarzenia ze wszystkich kursów,';
$string['gotocalendarsnap'] = 'przejdź do witryny kalendarza.';
$string['quizattemptswarn'] = 'Wyklucza podejścia zawieszonych użytkowników';
$string['quizfeedback'] = 'Opinie zwrotne';
$string['validratio'] = 'Ta kombinacja kolorów jest zgodna z minimalną wartością współczynnika wg normy WCAG 2.0 równą 4,5:1';
$string['invalidratio'] = 'Ta kombinacja kolorów nie jest zgodna z <a href="https://www.w3.org/TR/WCAG20-TECHS/G18.html" target="_blank">minimalną wartością współczynnika wg normy WCAG 2.0 równą 4,5:1</a>. Wartość: „{$a}”';
$string['imageinvalidratio'] = 'Ten obraz może być przyczyną problemów z kontrastem ze względu na niezgodność z minimalną wartością współczynnika wg normy WCAG 2.0 równą 4,5:1. Średnia wartość pikseli: „{$a}”';
$string['catinvalidratio'] = 'Następujące kategorie kolorów są niezgodne z <a href="https://www.w3.org/TR/WCAG20-TECHS/G18.html" target="_blank">minimalną wartością współczynnika wg normy WCAG 2.0 równą 4,5:1</a></a>: W odniesieniu do koloru tła witryny (białego): „{$a->white}”. W odniesieniu do koloru tła paska nawigacyjnego: „{$a->custombar}”. W odniesieniu do koloru tła przycisku Moje kursy: „{$a->customnav}”';
$string['spotinvalidratio'] = 'Kolor tła nie jest zgodny z <a href="https://www.w3.org/TR/WCAG20-TECHS/G18.html" target="_blank">minimalną wartością współczynnika wg normy WCAG 2.0 równą 4,5:1</a>. Aktualna wartość w odniesieniu do {$a->name}: {$a->value}.';
$string['imageinvalidratiocategory'] = 'Przy tym kolorze motywu ten obraz może być przyczyną problemów z kontrastem ze względu na niezgodność z minimalną wartością współczynnika wg normy WCAG 2.0 równą 4,5:1. Średnia wartość pikseli: „{$a}”';
$string['lazyload_mod_page'] = 'Włącz domyślne ładowanie opóźnione zasobów stron';
$string['lazyload_mod_page_description'] = 'Włączenie tego ustawienia pozwala znacząco skrócić czasy ładowania stron kursu w przypadku kursów wielostronicowych.';
$string['pmadvancedfeed_viewmore'] = 'Zobacz więcej';
$string['pmadvancedfeed_reload'] = 'Odswież';
$string['multimediacard'] = 'Pliki multimedialne nie będą wyświetlane w widokach kart aktywności w kompozycji Snap. Będą one używane na stronie głównej i stronach kursu tylko w przypadku małych kart aktywności i zasobów.';
$string['enabledlogin'] = 'Wyświetlane opcje logowania';
$string['enabledlogindesc'] = 'Wybierz opcje logowania, które mają być wyświetlane.';
$string['moodlelogin'] = 'Wyświetlaj tylko logowanie Moodle';
$string['alternativelogin'] = 'Wyświetlaj tylko alternatywne opcje logowania';
$string['bothlogin'] = 'Wyświetlaj obie opcje logowania';
$string['enabledloginorder'] = 'Kolejność opcji logowania';
$string['enabledloginorderdesc'] = 'Wybierz opcję logowania, która powinna być wyświetlana jako pierwsza.';
$string['moodleloginfirst'] = 'Wyświetlaj logowanie Moodle jako pierwsze';
$string['alternativeloginfirst'] = 'Wyświetlaj alternatywne opcje logowania jako pierwsze';
$string['alternativeloginoptions'] = 'Alternatywne opcje logowania';
$string['openmessagedrawer'] = 'Otwórz szufladę wiadomości.';
$string['refreshdeadlinestask'] = 'Odśwież zbuforowane dane o terminach. To zadanie powinno być uruchamiane przed zalogowaniem się wszystkich użytkowników.';
$string['resetdeadlinesquerycounttask'] = 'Resetuj licznik zapytań o terminy';
$string['refreshdeadlinestaskoff'] = 'Nie szukano danych do wprowadzenia. Włącz funkcję „Odśwież terminy dla zaplanowanych zadań” w ustawieniach menu osobistego Snap, aby w ramach zadania móc wprowadzać scachowane dane dotyczące terminów.';
$string['activityrestriction'] = 'Ograniczenie aktywności';
$string['hideandshowactioncb'] = 'Ukryj i pokaż pole wyboru dla aktywności';
$string['retryfeed'] = 'Ten kanał jest obecnie niedostępny. Sprawdź później. Kanał: {$a}';
$string['loadingfeed'] = 'Trwa ładowanie...może to zająć trochę czasu';
$string['hvpcustomcss'] = 'Niestandardowy CSS H5P';
$string['hvpcustomcssdesc'] = 'Niestandardowy CSS do modułu H5P (moodle.org/plugins/mod_hvp), jeśli jest zainstalowany.';
$string['courselimitstrdanger'] = 'Pasek postępu osiągnięcia limit kursu nie będzie wyświetlany.';
$string['courselimitstrwarning'] = 'Jeśli lista zawiera więcej niż {$a} kursy/kursów, pasek postępu nie będzie wyświetlany';
$string['tilesformatcoursehomealttext'] = 'Strona główna kursu';
$string['editmodetiles'] = 'Edytuj treść';
$string['totop'] = 'Przejdź na górę';
$string['loginsetting'] = 'Strona logowania';
$string['loginbgimgheading'] = 'Szablon strony logowania';
$string['loginbgimgheadingdesc'] = 'Snap pozwala na wybór rozmaitych szablonów do wyświetlania na stronie logowania. Wybierz spośród różnych opcji w menu rozwijanym poniżej.';
$string['loginpagetemplate'] = 'Wybierz szablon strony logowania, który ma zostać użyty';
$string['classic_template'] = 'Klasyczny szablon';
$string['loginbgimg'] = 'Obrazek tła strony logowania';
$string['loginbgimgdesc'] = 'Wybierz obrazy, które mają pojawić się w tle strony logowania. Aby obrazy lepiej się wyświetlały, prześlij pliki w formacie obrazu 16:9 (rozdzielczość 720p lub wymiary 1280 × 720 pikseli). Przesłane obrazy muszą mieć te same wymiary, aby uzyskać prawidłową wizualizację.';
$string['stylish_template'] = 'Stylowy szablon';
$string['activityedit'] = 'Edytuj aktywność';
$string['snapfeedsblocktitle'] = 'Kanały Snap';
$string['tiktok'] = 'TikTok';
$string['tiktokdesc'] = 'Adres URL Twojego konta w serwisie TikTok.';
$string['snapfootersettings'] = 'Stopka Snap';
$string['snapfootercustomization'] = 'Dostosowanie stopki';
$string['snapfootercustomizationdesc'] = 'Snap umożliwia dostosowanie stopki motywu, która jest wyświetlana w całej witrynie. Zwiększ komfort użytkowania, dodając przydatne łącza, zasoby pomocy technicznej lub inne cenne informacje o organizacji, które chcesz udostępnić uczącym się i nauczycielom.';
$string['snapfootercolors'] = 'Kolory stopki witryny';
$string['snapfootercolorsdesc'] = 'Kolory stopki można zmienić: aby zmienić kolor tła i/lub kolor tekstu, zaznacz je w następujących próbnikach kolorów.';
$string['snapfooterbgcolor'] = 'Kolor tła stopki';
$string['snapfootertxtcolor'] = 'Kolor tekstu stopki';
$string['enableblockmyoverviewwarning'] = 'Blok przeglądu kursu jest wyłączony. Aby wyświetlić kursy, włącz blokadę.';
$string['collapseicon'] = 'Zwiń zawartość';
$string['expandicon'] = 'Rozwiń zawartość';
