<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @copyright  Copyright (c) 2020 Open LMS. (http://www.openlms.net)
 * @license    http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['aboutcourse'] = 'Bu ders hakkında';
$string['activity'] = 'Etkinlik';
$string['action:changeassetvisibility'] = 'varlık görünürlüğünü değiştir';
$string['action:duplicateasset'] = 'varlığı kopyala';
$string['action:changesectionvisibility'] = 'bölüm görünürlüğünü değiştir';
$string['action:highlightsectionvisibility'] = 'bölüm görünürlüğünü vurgula';
$string['action:sectiontoc'] = 'bölümün içindekiler tablosunu al';
$string['addanewsection'] = 'Yeni bir bölüm oluştur';
$string['addresourceoractivity'] = 'Öğrenim etkinliği oluştur';
$string['admin'] = 'Yönetici';
$string['advancedbrandingheading'] = 'Gelişmiş markalama';
$string['ago'] = 'önce';
$string['answered'] = 'Yanıtlandı';
$string['appendices'] = 'Araçlar';
$string['arialabelnewsarticle'] = 'haber makalesi';
$string['assigndraft'] = 'Taslak onayınızı gerektiriyor';
$string['assignreopened'] = 'Yeniden açıldı';
$string['at'] = 'saatinde';
$string['attempted'] = 'Denendi';
$string['basics'] = 'Temel bilgiler';
$string['brandingheading'] = 'Markalama';
$string['browse'] = 'Gözat';
$string['browseallcourses'] = 'Tüm derslere gözat';
$string['cachedef_activity_deadlines'] = 'Kullanıcıların etkinlik teslim tarihleri için önbellek deposu.';
$string['cachedef_generalstaticappcache'] = 'Snap genel statik uygulama seviyesi önbelleği';
$string['cachedef_course_completion_progress'] = 'Ders/kullanıcı başına tamamlama verisinin önbelleğe alınması için kullanılır.';
$string['cachedef_course_completion_progress_ts'] = 'Bu da, bir ders veya modülde ders tamamlama ayarları değişirse oturum seviyesi önbelleklerinin geçersiz kılınması için kullanılır.';
$string['cachedef_webservicedefinitions'] = 'Otomatik olarak üretilen web hizmeti tanımlarının önbelleğe alınması.';
$string['card'] = 'Kart';
$string['categoryedit'] = 'Kategoriyi düzenle';
$string['category_color'] = 'Kategori rengi';
$string['category_color_description'] = 'Ders Kategorisi rengi. Alt dersler, en yakın üst kategori yapılandırmasını alır';
$string['category_color_palette'] = 'Renk paleti';
$string['category_color_palette_description'] = 'Verilen renk için ilgili onaltılık değere bakın. Bu işlem, herhangi bir yapılandırmayı etkilemez. Sadece kullanıcıların yapılandırma değerini anlaması için bir örnektir.';
$string['changecoverimage'] = 'Kapak görüntüsünü değiştir';
$string['changefullname'] = 'Site adını değiştir';
$string['chapters'] = 'Bölümler';
$string['choosereadme'] = '<div class="clearfix"><div class="theme_screenshot"><h2>Snap</h2><img class=img-polaroid src="snap/pix/screenshot.jpg" /></div></div>';
$string['close'] = 'Kapat';
$string['conditional'] = 'Koşullu';
$string['contents'] = 'İçindekiler';
$string['contributed'] = 'Katkıda bulunulan';
$string['courses'] = 'Dersler';
$string['coursecontacts'] = 'Ders Kişileri';
$string['coursedisplay'] = 'Ders ekranı';
$string['coursefootertoggle'] = 'Ders altbilgisi';
$string['coursefootertoggledesc'] = 'Ders altbilgisi, bir ders sayfasında kullanıcılara ders kişileri, ders tanımı ve dersteki son etkinlikler gibi gerekli bilgileri gösterir.';
$string['courseformatnotification'] = 'Şu anda kullandığınız ders biçimi Snap teması tarafından tam olarak desteklenmiyor. Open LMS, en iyi deneyim için Snap temasıyla birlikte Konular veya Haftalık ders biçimlerinin kullanılmasını önerir. Ders biçimi, <a href="{$a}">ders ayarları</a> içinden değiştirilebilir.';
$string['coursefixydefaulttext'] = 'Şu anda herhangi bir kursa kayıtlı değilsiniz.<br>Kayıtlı olduğunuz kurslar burada görüntülenecektir.';
$string['coursegrade'] = 'Ders notu:';
$string['coursepartialrender'] = 'Ders bölümleri için yavaş yüklemeyi etkinleştir';
$string['coursepartialrenderdesc'] = 'Etkinleştirildiğinde, ders bölümleri bir kullanıcı tarafından seçildiğinde istek üzerine yüklenir. Bu, büyük miktarda içeriğe sahip derslerin daha hızlı yüklenmesine yardımcı olur.';
$string['coursenavigation'] = 'Ders gezintisi';
$string['coursesummaryfilesunsuitable'] = 'Kapak resmini değiştirmeden önce lütfen ders özeti dosyalarınızı boşaltın';
$string['courseactionslabel'] = 'eylemler';
$string['courseactivitieslabel'] = 'Bölüm etkinlikleri';
$string['coursetools'] = 'Ders Panosu';
$string['coverdisplay'] = 'Kapak görüntüsü';
$string['covercarousel'] = 'Kapak atlıkarıncası';
$string['covercarousellabel'] = 'Kayar menü';
$string['covercarouselon'] = 'Kapak atlıkarıncası kullan';
$string['covercarouseldescription'] = '<p>Atlıkarınca, sitenizin ana sayfasında kapak resmi yerine görüntülenen bir dizi dönen başlık ya da bir slayt gösterisidir.</p>
<p>3 taneye kadar resim, her slayt için bir başlık ve isteğe bağlı olarak altyazı ekleyin. 1200 x 600 piksel büyüklüğündeki resimler en iyi sonucu verir.</p>';
$string['covercarouselsronly'] = 'Bu, otomatik olarak dönen slaytlara sahip bir atlıkarıncadır. Dönme özelliğini devre dışı bırakmak için düğmelerden herhangi birini etkinleştirin. Gezinmek için Önceki ve Sonraki düğmelerini kullanın veya slayt noktalarını kullanarak belirli bir slayta atlayın.';
$string['covercarouselplaybutton'] = 'Atlıkarınca için otomatik dönen slaytları sürdürün.';
$string['covercarouselpausebutton'] = 'Atlıkarınca için otomatik dönen slaytları duraklatın.';
$string['coverimage'] = 'Kapak görüntüsü';
$string['covervideo'] = 'Kapak videosu';
$string['comingsoon'] = 'Yakında geliyor!';
$string['createsection'] = 'Bölüm oluştur';
$string['current'] = 'Mevcut';
$string['customcss'] = 'Özel CSS';
$string['customcssdesc'] = 'Lütfen yetki arttıkça sorumluluğun da artacağını lütfen unutmayın. Buraya eklenen CSS ile ilgili her sorunu çözme sorumluluğu size aittir. Open LMS Desteği, CSS ile ilgili içerikler konusunda yardım sağlamaz ve sorunları gidermez.';
$string['customtopbar'] = 'Gezinti çubuğu';
$string['customisenavbar'] = 'Gezinti çubuğu renklerini değiştir';
$string['customisenavbutton'] = 'Derslerim düğmesi renklerini değiştir';
$string['customisecustommenu'] = 'Özel menü metin rengini değiştirme';
$string['custommenutext'] = 'Özel menü metin rengi';
$string['deadlines'] = 'Bitiş Tarihleri';
$string['deadlinestoggle'] = 'Bitiş Tarihleri';
$string['deadlinestoggledesc'] = 'Kullanıcılara kaydolunan derslerin varsa yaklaşan etkinlik bitiş tarihlerini gösterin.';
$string['defaultsummary'] = 'Bu alanı, bu konunun ne hakkında olduğunu; metin yoluyla, resim, ses ve video kullanarak açıklamak için kullanın.';
$string['defaultintrosummary'] = 'Yeni dersine hoş geldin {$a}. <br>Metin, resim, ses ve video yoluyla dersinin ne hakkında olduğunu anlatarak başlayın.';
$string['defaulttopictitle'] = 'Başlığı Olmayan Konu';
$string['debugerrors'] = 'Hata Ayıklama Hataları';
$string['deleteassetconfirm'] = 'Sil {$a}';
$string['deletingasset'] = '{$a} siliniyor';
$string['deletingassetname'] = '{$a->type} "{$a->name}" siliniyor';
$string['deletesectionconfirm'] = 'Bölümü Sil';
$string['deletingsection'] = '"{$a}" bölümü siliniyor';
$string['draft'] = 'Öğrencilere yayımlanmayan';
$string['dropzonelabel'] = 'Eklemek için dosyaları buraya bırakın veya dosyalara <span class="fake-link">göz atın</span>';
$string['due'] = 'Teslim tarihi {$a}';
$string['edit'] = '"{$a}" öğesini düzenle';
$string['editcoursecontent'] = 'Blokları düzenle';
$string['editcoursesettings'] = 'Ders ayarları';
$string['editcoursetopic'] = 'Bölümü düzenle';
$string['editcustomfooter'] = 'Altbilgiyi düzenle';
$string['editcustommenu'] = 'Özel menüyü düzenle';
$string['error'] = 'Hata';
$string['errorgettingfeed'] = 'Akış öğeleri alınırken hata oluştu.';
$string['error:categorycolorinvalidjson'] = 'Ders kategorileri için yanlış JSON biçimi';
$string['error:categorycolorinvalidvalue'] = '"{$a}" kategorisi için kayıt kimliği veya renk değeri geçerli değil';
$string['error:categorynotfound'] = '"{$a}" kimliğine sahip kategori kaydı bulunamadı';
$string['error:coverimageexceedsmaxbytes'] = 'Kapak görüntüsü, site seviyesinde izin verilen maksimum dosya boyutunu ({$a}) aşıyor';
$string['error:coverimageresolutionlow'] = 'En iyi görünüm için, en az 1024 piksel genişliğinde daha büyük bir görüntü kullanılmasını öneririz.';
$string['error:duplicatedcategoryids'] = 'Yanlış JSON biçimi, bazı kimlikler yinelenmiş';
$string['error:failedtochangeassetvisibility'] = 'Varlık gizlenemedi/gösterilemedi';
$string['error:failedtochangesectionvisibility'] = 'Bölüm gizlenemedi/gösterilemedi';
$string['error:failedtohighlightsection'] = 'Bölüm vurgulanamadı';
$string['error:failedtoduplicateasset'] = 'Kopyalanamadı';
$string['error:failedtodeleteasset'] = 'Varlık silinemedi';
$string['error:failedtotoc'] = 'İçindekiler tablosu alınamadı.';
$string['extension'] = 'Uzantı {$a}';
$string['facebook'] = 'Facebook';
$string['facebookdesc'] = 'Facebook sayfanızın url\'si.';
$string['favicon'] = 'Sık kullanılan simge';
$string['favicondesc'] = 'Sık kullanılan simgeler web tarayıcınızın adres çubuğunda, bir kullanıcının yer imleri içinde ve mobil kısayollarında yer alır.';
$string['favorite'] = 'Sık kullanılan {$a}';
$string['favorited'] = 'Sık kullanılanlara eklenen {$a}';
$string['featurespots'] = 'Özellik noktaları';
$string['featurespotsedit'] = 'Özellik noktalarını düzenle';
$string['featurespotshelp'] = '<p>Mevcut ve potansiyel kullanıcılar için temel faydaları vurgulamak üzere sitenizin ön sayfasına 3 adede kadar özellik noktası ekleyin.</p>
<p>Her özelliğe bir görüntü, başlık ve içerik açıklaması ekleyebilirsiniz. Özelliği ön sayfada görmek için bir başlık girmeniz gerekir. Görüntü ve içerik açıklaması bölümleri isteğe bağlıdır.</p>
<p>Önerilen görüntü boyutu karedir ve 200 piksele 200 pikselden büyük değildir.</p>';
$string['featurespotsheading'] = 'Özellik noktaları başlığı';
$string['featureonetitle'] = 'Özellik 1 başlığı';
$string['featuretwotitle'] = 'Özellik 2 başlığı';
$string['featurethreetitle'] = 'Özellik 3 başlığı';
$string['featureonetitlelink'] = 'Özellik 1 başlık bağlantısı';
$string['featuretwotitlelink'] = 'Özellik 2 başlık bağlantısı';
$string['featurethreetitlelink'] = 'Özellik 3 başlık bağlantısı';
$string['featuretitlelinkdesc'] = 'Bu özellik noktasını bağlamak istediğiniz URL\'yi yazın. Sitenize haricî veya dâhilî bağlantılar ekleyebilirsiniz. Dâhilî bağlantı eklemek için lütfen / işaretini de içerecek şekilde site URL\'sinden bağlantıyı kopyalayın. Örneğin, bir kursa bağlantı vermek için "course/view.php?id=160" kullanılır. Haricî bir bağlantı eklemek için bağlantıyı https:// ile başlatın';
$string['featureonetitlecb'] = 'Özellik 1\'i yeni pencerede aç';
$string['featuretwotitlecb'] = 'Özellik 2\'yi yeni pencerede aç';
$string['featurethreetitlecb'] = 'Özellik 3\'ü yeni pencerede aç';
$string['featuretitlecbdesc'] = 'Bu ayar etkinleştirilirse belirtilen noktaya eklenen bağlantı, yeni bir pencerede açılır';
$string['featureonetext'] = 'Özellik 1 içeriği';
$string['featuretwotext'] = 'Özellik 2 içeriği';
$string['featurethreetext'] = 'Özellik 3 içeriği';
$string['featureoneimage'] = 'Özellik 1 resmi';
$string['featuretwoimage'] = 'Özellik 2 resmi';
$string['featurethreeimage'] = 'Özellik 3 resmi';
$string['featuredcourses'] = 'Öne çıkan dersler';
$string['featuredcourseshelp'] = 'Sitenizin ön sayfasında 8 adede kadar öne çıkan dersi vurgulayın. Bir dersi öne çıkarmak için Ders kimliğini girin.';
$string['featuredcoursesheading'] = 'Öne çıkan dersler başlığı';
$string['featuredcourseone'] = 'Öne çıkan ders 1';
$string['featuredcoursetwo'] = 'Öne çıkan ders 2';
$string['featuredcoursethree'] = 'Öne çıkan ders 3';
$string['featuredcoursefour'] = 'Öne çıkan ders 4';
$string['featuredcoursefive'] = 'Öne çıkan ders 5';
$string['featuredcoursesix'] = 'Öne çıkan ders 6';
$string['featuredcourseseven'] = 'Öne çıkan ders 7';
$string['featuredcourseeight'] = 'Öne çıkan ders 8';
$string['featuredcoursesedit'] = 'Öne çıkan dersleri düzenle';
$string['featuredcoursesbrowseall'] = 'Tüm derslere gözat';
$string['featuredcoursesbrowsealldesc'] = 'Tüm derslere gözat bağlantısı ekle';
$string['feature_spot_background_color'] = 'Arka plan rengi';
$string['feature_spot_title_color'] = 'Başlık metni rengi';
$string['feature_spot_description_color'] = 'Açıklama metni rengi';
$string['feature_spot_title_color_lower'] = 'başlık metni rengi';
$string['feature_spot_description_color_lower'] = 'açıklama metni rengi';
$string['feedbackavailable'] = 'Geri bildirim mevcut';
$string['feedbacktoggle'] = 'Geri bildirim ve not verme';
$string['feedbacktoggledesc'] = 'Öğrencilere en son geri bildirimlerini ve eğitmenlere not verilmesi gereken en son gönderileri göster.';
$string['footnote'] = 'Site altbilgisi';
$string['footnotedesc'] = 'Site bilgilerinizi HTML olarak ekleyebilir ve bağlantılar, görüntüler veya olay listeleri verebilirsiniz.';
$string['forcepwdwarningpersonalmenu'] = 'Kişisel menünüzü kullanmaya başlamadan önce <a href="{$a}">parolanızı değiştirmelisiniz</a>.';
$string['forumauthor'] = 'Yazar';
$string['forumlastpost'] = 'Son gönderi';
$string['forumpicturegroup'] = 'Grup';
$string['forumreplies'] = 'Yanıtlar';
$string['forumtopic'] = 'Konu';
$string['forumposts'] = 'Forum gönderileri';
$string['forumpoststoggle'] = 'Forum gönderileri';
$string['forumpoststoggledesc'] = 'Kullanıcılarınıza, derslerinden gelen en son 10 forum gönderisini gösterin';
$string['fullname'] = 'Site adı';
$string['fullnamedesc'] = 'Sitenizin adı.';
$string['graderadviseuserreport'] = '"Not veren raporu" mobil cihazlarda çok iyi çalışmaz. Yerine "kullanıcı raporu" önerilmektedir';
$string['grading'] = 'Not Verme';
$string['help'] = 'Yardım';
$string['helpguide'] = 'Yardım kılavuzu';
$string['headingfont'] = 'Başlık yazı tipi';
$string['headingfont_desc'] = 'Bu tırnaksız yazı tipi sitenizdeki başlıklarda (h1-h6 öğeleri) kullanılır. Özel bir web yazı tipi ekliyorsanız bunu Moodle ek HTML\'sine eklemeyi unutmayın. Diğer öğelerin yazı tiplerini değiştirmek isterseniz lütfen Özel CSS seçeneğini kullanın. Bunu nasıl yapacağınızla ilgili örnekler için lütfen bu <a href="https://help.openlms.net/en/administrator/manage-a-site/snap-font-family-with-custom-css/" target="_blank">belgeye</a> göz atın.';
$string['helpwithlogin'] = 'Oturum açma yardımı';
$string['helpwithloginandguest'] = 'Oturum açma / konuk erişimi yardımı';
$string['loginrequiredmessage'] = '* gerekli bir alanı belirtir';
$string['hiddencoursestoggle'] = 'Gizli dersler';
$string['highlightedsection'] = 'vurgulanan';
$string['home'] = 'ana sayfa';
$string['image'] = 'görüntü';
$string['images'] = 'Görüntüler';
$string['instagram'] = 'Instagram';
$string['instagramdesc'] = 'Instagram hesabınızın url\'si.';
$string['introduction'] = 'Giriş';
$string['jsontext'] = 'JSON Metni';
$string['jsontextdescription'] = 'Metin alanı verilen JSON\'u doğrular, bu nedenle yalnızca mevcut kategorilere izin verilir, kimlik kayıtları (kategori kayıtları) olarak yalnızca sayısal değerler geçerlidir ve renkler olarak yalnızca onaltılık değerler kabul edilir. Bir örnek:<br>{"1":"#FAAFFF",<br>"45":"#AFF",<br>"65":"#FFF228",<br>"12":"#CC0084",<br>"56":"#CC0087",<br>"89":"#CCF084"}';
$string['knowledgebase'] = 'Blackboard Open LMS Bilgi Bankası';
$string['list'] = 'Liste';
$string['linkedin'] = 'LinkedIn';
$string['linkedindesc'] = 'Kuruluşunuza ait LinkedIn url\'si.';
$string['leftnav'] = 'İçindekiler';
$string['leftnavdesc'] = 'İçindekiler\'in nerede görüntüleneceğini seçin. Liste görünümü içerik için daha fazla yer sağlar ve birçok konusu olan kurslar için daha uygundur.';
$string['loading'] = 'Yükleniyor...';
$string['loggedinasguest'] = 'Konuk olarak oturum açtınız';
$string['loggedoutmsg'] = 'Oturumunuz sona ermiş durumda. Bu siteyi kullanmaya devam etmek için lütfen tekrar oturum açın.';
$string['loggedoutmsgtitle'] = 'Otumunuz kapandı';
$string['loggedoutfailmsg'] = '{$a} için oturum açmanız gerekli.';
$string['loginform'] = 'Oturum Aç';
$string['logo'] = 'Logo';
$string['logodesc'] = 'Logonuz tüm site boyunca başlıkta görüntülenir.';
$string['menu'] = 'Derslerim';
$string['messageread'] = 'Okunmuş İletiler';
$string['messages'] = 'İletiler';
$string['messagestoggle'] = 'İletiler';
$string['messagestoggledesc'] = 'Kullanıcılara son 12 hafta içinde aldıkları en son mesajları gösterin. Bu seçeneği etkinleştirmek için Gelişmiş Özellikler sayfasındaki mesajlaşma özelliğinin etkinleştirildiğinden emin olun.';
$string['more'] = 'Daha Fazla';
$string['morenews'] = 'Daha fazla haber';
$string['moreoptionslabel'] = 'Daha Fazla Seçenek';
$string['movingstartedhelp'] = '"{$a}" bölümünü yerleştirmek istediğiniz yere gidin';
$string['movingdropsectionhelp'] = '"{$a->moving}" bölümünü "{$a->before}" bölümünün önüne yerleştirin';
$string['moving'] = '"{$a}" taşınıyor';
$string['movingcount'] = '{$a} nesne taşınıyor';
$string['movefailed'] = '"{$a}" için taşıma işlemi başarısız';
$string['move'] = '"{$a}" öğesini taşı';
$string['movehere'] = 'Buraya taşı';
$string['movesection'] = 'Bölümü taşı';
$string['navbarbg'] = 'Arka plan rengi';
$string['navbarlink'] = 'Metin rengi';
$string['navbarbuttoncolor'] = 'Arka plan rengi';
$string['navbarbuttonlink'] = 'Metin rengi';
$string['nextsection'] = 'Bir sonraki bölüm';
$string['nodeadlines'] = 'Hiç yaklaşan son teslim tarihiniz yok.';
$string['noforumposts'] = 'Hiç önemli forum gönderiniz yok.';
$string['nograded'] = 'Hiç son dönemde alınan geri bildiriminiz yok.';
$string['nograding'] = 'Hiç not vereceğiniz gönderiniz yok.';
$string['nomessages'] = 'Hiç iletiniz yok.';
$string['notanswered'] = 'Yanıtlanmayan';
$string['notattempted'] = 'Denenmedi';
$string['notcontributed'] = 'Katkıda bulunulmayan';
$string['notpublished'] = 'Öğrencilere yayımlanmayan';
$string['notsubmitted'] = 'Teslim edilmeyen';
$string['overdue'] = 'Süresi geçmiş';
$string['pausegraphicsanim'] = 'GIF animasyonunu duraklatın.';
$string['personalmenu'] = 'Kişisel menü';
$string['personalmenuandsnapfeeds'] = 'Kişisel menü ve Snap akışları';
$string['personalmenufeatures'] = 'Kişisel menü özellikleri';
$string['personalmenulogintoggle'] = 'Oturum açma sonrasında kişisel menüyü göster';
$string['personalmenulogintoggledesc'] = 'Oturum açılır açılmaz kişisel menüyü açar';
$string['personalmenuadvancedfeedsenable'] = 'Gelişmiş beslemeleri etkinleştir';
$string['personalmenuadvancedfeedsenabledesc'] = 'Gelişmiş beslemeler, daha kısa yükleme süresi sağlayan ve istek üzerine içeriği yenileyebilen bazı kişisel menü öğelerini yükler.';
$string['personalmenuadvancedfeedsperpage'] = 'Gelişmiş beslemelerde öğe görüntüleme sayısı';
$string['personalmenuadvancedfeedsperpagedesc'] = 'Akışta gösterilecek öğe sayısını seçin. Kullanıcılar ek öğeleri görüntülemek için <strong>Daha fazla görüntüle</strong> seçeneğini belirleyebilir.';
$string['personalmenuadvancedfeedslifetime'] = 'Gelişmiş akış kullanım süresi';
$string['personalmenuadvancedfeedslifetimedesc'] = 'Akışların oturum açma sonrasında tarayıcıda ne kadar süreyle önbellekte tutulacağını seçin. "0" değeri atandığında akışlar tarayıcıda önbellekte tutulmaz.';
$string['personalmenurefreshdeadlines'] = 'Zamanlanmış görev kullanarak bitiş tarihlerini yenile';
$string['personalmenurefreshdeadlinesdesc'] = 'Görev çalıştığında daha hızlı sayfa yükleme süreleri için bitiş tarihi verileri yenilenecektir.';
$string['personalmenuenablepersonalmenu'] = 'Kişisel menüyü etkinleştirin';
$string['personalmenuenablepersonalmenuheading'] = 'Kişisel menü';
$string['personalmenuenablepersonalmenuheadingdesc'] = 'Not: Kişisel Menü devre dışı bırakılırsa Kurslarım sayfasından kurslarınıza erişebilirsiniz. Kursların sayfada görülebilmesi için lütfen Kursa genel bakış blokunun etkinleştirildiğinden emin olun.';
$string['personalmenuenablepersonalmenudesc'] = 'Kurslarım bağlantısı kişisel menüyü açar. Devre dışı bırakılırsa Kurslarım sayfasına yönlendirilir.';
$string['mycoursessnapfeedsheading'] = 'Snap akışları';
$string['mycoursessnapfeedsdesc'] = 'Not: <strong>Gelişmiş Beslemeler</strong> yalnızca <strong>Son Tarihler</strong>, <strong>Geri Bildirim ve not verme</strong>, <strong>Mesajlar</strong> veya <strong>Forum gönderileri</strong> seçeneklerinden en az biri seçildiğinde kullanılabilir hale gelir.';
$string['refreshdeadlinestasksettingheading'] = 'Zamanlanmış bitiş tarihleri görevini yenile';
$string['pld'] = 'PLD';
$string['pluginname'] = 'Snap';
$string['poster'] = 'Kapak görüntüsü';
$string['posterdesc'] = 'Sitenizin ön sayfası için büyük bir başlık görüntüsü. Yatay yönlendirilmiş (1200 x600 piksel) veya daha büyük resimler en iyisidir.';
$string['poweredbyrunby'] = '<a href="https://moodle.com/" target="_blank" rel="noopener">Moodle</a> tabanlı bir ürün olan <a href="https://{$a->subdomain}.openlms.net/" target="_blank" rel="noopener">OpenLMS</a> ile üretilmiştir.<br>Telif hakları © {$a->year} Open LMS, Tüm Hakları Saklıdır.';
$string['previoussection'] = 'Bir önceki bölüm';
$string['privacy:metadata:theme_snap_course_favorites:courseid'] = 'Kullanıcının sık kullanılanlara eklediği dersin kimliği';
$string['privacy:metadata:theme_snap_course_favorites:userid'] = 'Dersi sık kullanılanlara ekleyen kullanıcının kullanıcı kimliği';
$string['privacy:metadata:theme_snap_course_favorites:timefavorited'] = 'Kullanıcının dersi sık kullanılanlara eklediği zamanı belirten zaman damgası';
$string['privacy:metadata:theme_snap_course_favorites'] = 'Kullanıcının Snap için sık kullanılanlara eklediği dersleri depolar';
$string['problemsfound'] = 'Bulunan Sorunlar';
$string['progress'] = 'İlerleme';
$string['readmore'] = 'Devamını oku »';
$string['recentactivity'] = 'En Son Etkinlik';
$string['recentfeedback'] = 'Geri bildirim';
$string['region-main'] = 'Ana';
$string['region-side-main-box'] = 'Ana';
$string['region-side-post'] = 'Sağ';
$string['region-side-pre'] = 'Sol';
$string['region-side-top'] = 'Üst';
$string['released'] = 'Yayımlanma tarihi: {$a}';
$string['reopened'] = 'Yeniden açıldı';
$string['resourcedisplay'] = 'Kaynak görüntüsü';
$string['resourcedisplayhelp'] = 'Dersinizde eklerin ve bağlantıların nasıl göründüğünü seçin. Snap teması, küçük etkinlik ve kaynak kartlarının açıklamasındaki multimedya dosyalarını desteklemez.';
$string['resumegraphicsanim'] = 'GIF animasyonunu sürdürün.';
$string['displaydescription'] = 'Açıklamayı göster';
$string['displaydescriptionhelp'] = 'Önce yeni bir sayfada kaynak etkinliklerinin açıklamasını göstermek için bunu seçin. Öğrenciler içeriğe açıklama üzerinden erişirler.';
$string['search'] = 'İçeriği ara';
$string['showcoursegradepersonalmenu'] = 'Notlar';
$string['showcoursegradepersonalmenudesc'] = 'Kullanıcılara kişisel menü içindeki ders kartlarında notlarını göster';
$string['socialmedia'] = 'Sosyal medya';
$string['submitted'] = 'Gönderilen';
$string['sitedescription'] = 'Site açıklaması';
$string['subtitle'] = 'Altyazı';
$string['subtitle_desc'] = 'Sitenizi kullanıcılarınıza kısaca tanıtın.';
$string['summarylabel'] = 'Bölüm özeti';
$string['themecolor'] = 'Site rengi';
$string['themecolordesc'] = 'En iyisi parlak renklerdir ve sitenize modern bir hava verir.';
$string['title'] = 'Unvan';
$string['top'] = 'Üst';
$string['topbarbgcolor'] = 'Gezinti çubuğu rengi';
$string['topbarlinkcolor'] = 'Gezinti çubuğu bağlantı ve simge rengi';
$string['topbarbuttoncolor'] = 'Derslerim\'in arka planı';
$string['togglenavigation'] = 'Gezintiyi aç kapa';
$string['topicactions'] = 'Konu eylemleri';
$string['xakatwitterdesc'] = 'hesabınızın url\'si.';
$string['unenrolme'] = 'Kaydımı sil';
$string['enrolme'] = 'Beni kaydet';
$string['unread'] = 'okunmamış';
$string['unsupportedcoverimagetype'] = 'Desteklenmeyen kapak resmi türü ({$a})';
$string['via'] = 'yoluyla';
$string['viewcourse'] = 'Derse Bak';
$string['viewmore'] = 'Daha fazlasına bak';
$string['viewyourprofile'] = 'Profili görüntüle';
$string['viewmyfeedback'] = 'Geri bildirimimi görüntüle';
$string['viewcalendar'] = 'Takvimimi görüntüle';
$string['viewforumposts'] = 'Forum gönderilerimi görüntüle';
$string['viewmessaging'] = 'İletilerimi görüntüle';
$string['vieworiginalimage'] = 'Orijinal görüntüyü görüntüle';
$string['visibility'] = 'Görünürlük';
$string['xofyanswered'] = '{$a->completed} / {$a->participants} Yanıtladı';
$string['xofyattempted'] = '{$a->completed} / {$a->participants} Denedi';
$string['xofycontributed'] = '{$a->completed} / {$a->participants} Katkıda bulundu';
$string['xofysubmitted'] = '{$a->completed} / {$a->participants} Teslim etti';
$string['xungraded'] = '{$a} Not Verilmeyen';
$string['youtube'] = 'YouTube';
$string['youtubedesc'] = 'Youtube kanalınızın url\'si.';
$string['showallsectionsdisabled'] = 'Tasarım dili nedeniyle "Tüm bölümleri bir sayfada göster" seçeneği Snap\'te kullanılamaz.';
$string['disabled'] = 'Devre dışı';
$string['showappearancedisabled'] = 'Snap\'in tasarım dili "Görünüm" ayarlarının değiştirilmesini önler.';
$string['pbb'] = 'Profil tabanlı markalama';
$string['pbb_description'] = '<strong>Profil tabanlı markalamayı</strong> etkinleştirerek, seçilen kullanıcı profili alanına göre belirli kullanıcı grupları için markalama deneyimini özelleştirebilirsiniz.<ul><li>Kullanıcı alanı değeri tüm karakterleri küçük harfe dönüştürülerek ve tire (-) ile ayrılarak <em>dizileştirilir</em></li>
<li>Başına <code>snap-pbb-</code> dizesi eklenir</li>
<li>Bu sınıf <code>body</code> HTML etiketine eklenir</li></ul>Örneğin, <em>Blueberry Extravaganza</em> kullanıcı alanı değeri <code>snap-pbb-blueberry-extravaganza</code> olarak dizileştirilir<br /><br />Bu özellik Özel CSS ile birlikte kullanılır. Bunun için <a class="snap-settings-tab-link" href="#themesnapbranding">Temel Bilgiler</a> bölümündeki yeni sınıfları kullanarak CSS seçicileri eklemeniz gerekir.';
$string['pbb_enable'] = 'Profil tabanlı markalamayı etkinleştir';
$string['pbb_enable_description'] = 'Etkinse body etiketine yalnızca sınıfı ekler.';
$string['pbb_field'] = 'Kullanılacak kullanıcı alanı';
$string['pbb_field_description'] = 'Bu alanın değeri dizileştirilir ve başına <code>snap-pbb-</code> eklenerek bir CSS sınıf adı olarak kullanılır.';
$string['cachedef_profile_based_branding'] = 'Profil tabanlı markalama için önbelleğe alma.';
$string['cachedef_course_card_bg_image'] = 'Ders arka plan görüntüsü için önbelleğe alma.';
$string['cachedef_course_card_teacher_avatar'] = 'Öğretmen avatarları için önbelleğe alma.';
$string['cachedef_course_card_teacher_avatar_index'] = 'Öğretmen avatarları dizini için önbelleğe alma.';
$string['accessforumstringdis'] = 'Görüntüleme seçenekleri';
$string['accessforumstringmov'] = 'Seçenekleri taşı';
$string['accesscalendarstring'] = 'Takvim';
$string['accessglobalsearchstring'] = 'Ara';
$string['admineventwarning'] = 'Tüm derslerdeki olayları görmek için,';
$string['gotocalendarsnap'] = 'site takvimine gidin.';
$string['quizattemptswarn'] = 'Askıya alınan kullanıcılara ait denemeleri hariç tutar';
$string['quizfeedback'] = 'Geri bildirim';
$string['validratio'] = 'Bu renk kombinasyonu WCAG 2.0 minimum oran değeri 4.5:1\'e uygun değil';
$string['invalidratio'] = 'Bu renk kombinasyonu <a href="https://www.w3.org/TR/WCAG20-TECHS/G18.html" target="_blank">WCAG 2.0 minimum oran değeri 4.5:1</a>\'e uygun değil. Değer: "{$a}"';
$string['imageinvalidratio'] = 'WCAG 2.0 minimum oran değeri 4.5:1\'e uygun olmadığından dolayı bu resimde kontrast sorunları olabilir. Ortalama piksel değeri: "{$a}"';
$string['catinvalidratio'] = 'Aşağıdaki renk kategorileri, Site arka plan rengine (beyaz) karşı: "{$a->white}". Gezinti çubuğu arka plan rengine karşı: "{$a->custombar}". Kurslarım düğmesi arka plan rengine karşı: "{$a->customnav}" içeren <a href="https://www.w3.org/TR/WCAG20-TECHS/G18.html" target="_blank">WCAG 2.0 minimum oran değeri 4.5:1</a>\'e uygun değil.';
$string['spotinvalidratio'] = 'Arka plan rengi WCAG<a href="https://www.w3.org/TR/WCAG20-TECHS/G18.html" target="_blank"> 2.0 minimum oran değeri 4.5:1</a>\'e uygun değil. {$a->name} değerine karşı geçerli değer: {$a->value}.';
$string['imageinvalidratiocategory'] = 'WCAG 2.0 minimum oran değeri 4.5:1\'e uygun olmadığından dolayı bu resimde tema rengiyle kontrast sorunları olabilir. Ortalama piksel değeri: "{$a}"';
$string['lazyload_mod_page'] = 'Sayfa kaynakları için varsayılan yavaş yüklemeyi etkinleştir';
$string['lazyload_mod_page_description'] = 'Etkinleştirildiğinde, bu ayar çok sayfalı dersler için ders sayfası yükleme sürelerini önemli ölçüde kısaltır.';
$string['pmadvancedfeed_viewmore'] = 'Daha fazlasına bak';
$string['pmadvancedfeed_reload'] = 'Yenile';
$string['multimediacard'] = 'Snap teması için etkinlik kartı görünümlerinde multimedya dosyaları gösterilmez. Bu, ana sayfa ve ders sayfalarında yalnızca küçük etkinlik ve kaynak kartları için uygulanır.';
$string['enabledlogin'] = 'Görüntülenen oturum açma seçenekleri';
$string['enabledlogindesc'] = 'Görüntülenmesi gereken oturum açma seçeneklerini seçin.';
$string['moodlelogin'] = 'Yalnızca Moodle oturumunu görüntüle';
$string['alternativelogin'] = 'Yalnızca alternatif oturum seçeneklerini görüntüle';
$string['bothlogin'] = 'Her iki oturumun seçeneğini görüntüle';
$string['enabledloginorder'] = 'Oturum açma seçeneklerinin sırası';
$string['enabledloginorderdesc'] = 'İlk olarak hangi oturum açma seçeneğinin görüntüleneceğini seçin.';
$string['moodleloginfirst'] = 'Önce Moodle oturumunu görüntüle';
$string['alternativeloginfirst'] = 'Önce alternatif oturum açma seçeneklerini görüntüle';
$string['alternativeloginoptions'] = 'Alternatif oturum açma seçenekleri';
$string['openmessagedrawer'] = 'Mesajlaşma çekmecesini aç.';
$string['refreshdeadlinestask'] = 'Bitiş tarihlerinin önbellek verilerini yenile. Bu, tüm kullanıcılar oturum açmadan önce çalıştırılmalıdır.';
$string['resetdeadlinesquerycounttask'] = 'Teslim tarihlerini sorgulama sayımını sıfırla';
$string['refreshdeadlinestaskoff'] = 'Doldurmak için veri aranmadı. Önbelleğe alınmış son tarih verilerini doldurmak için lütfen Snap\'in Kişisel menü ayarlarındaki “Son tarihleri planlanan görevi kullanarak yenile” ayarını açın.';
$string['activityrestriction'] = 'Etkinlik kısıtlama';
$string['hideandshowactioncb'] = 'Etkinlik onay kutusu eylemini gizle ve göster';
$string['retryfeed'] = 'Bu akış şu anda kullanılamıyor, lütfen daha sonra tekrar kontrol edin. Akış: {$a}';
$string['loadingfeed'] = 'Yükleniyor... İşlem zaman alabilir';
$string['hvpcustomcss'] = 'H5P Özel CSS';
$string['hvpcustomcssdesc'] = 'Yüklüyse H5P modülü (moodle.org/plugins/mod_hvp) için özel CSS.';
$string['courselimitstrdanger'] = 'Kurs sınırına ulaşıldı, ilerleme çubuğu görüntülenmez.';
$string['courselimitstrwarning'] = '{$a} adetten fazla kurs listelenirse ilerleme çubuğu görüntülenmez';
$string['tilesformatcoursehomealttext'] = 'Kurs ana sayfası';
$string['editmodetiles'] = 'İçeriği düzenle';
$string['totop'] = 'Başa git';
$string['loginsetting'] = 'Oturum açma sayfası';
$string['loginbgimgheading'] = 'Oturum açma sayfası şablonu';
$string['loginbgimgheadingdesc'] = 'Snap, oturum açma sayfasında görüntülenecek farklı şablonlar arasında geçiş yapılmasına olanak tanır. Lütfen aşağıdaki açılır menüdeki seçenekler arasında bir seçim yapın.';
$string['loginpagetemplate'] = 'Kullanılacak oturum açma sayfası şablonunu seçin';
$string['classic_template'] = 'Klasik şablon';
$string['loginbgimg'] = 'Oturum açma sayfası arka plan görseli';
$string['loginbgimgdesc'] = 'Oturum açma sayfasının arka planında görüntülenecek görselleri seçin. Daha iyi bir görsel deneyim için lütfen 16:9 en/boy oranına sahip dosyalar yükleyin (720 p çözünürlükte veya 1280x720 piksel boyutlarında). Doğru bir görselleştirme için yüklenen görüntülerin aynı boyutlarda olması gerekir.';
$string['stylish_template'] = 'Şık şablon';
$string['activityedit'] = 'Etkinliği düzenle';
$string['snapfeedsblocktitle'] = 'Snap akışları';
$string['tiktok'] = 'TikTok';
$string['tiktokdesc'] = 'TikTok hesabınızın url\'si.';
$string['snapfootersettings'] = 'Snap altbilgisi';
$string['snapfootercustomization'] = 'Altbilgi özelleştirme';
$string['snapfootercustomizationdesc'] = 'Snap, temanın site genelinde görüntülenen altbilgisinin özelleştirilmesine olanak tanır. Yararlı bağlantılar, destek kaynakları veya kuruluşunuz hakkında öğrenciler ve eğitimcilerle paylaşmak istediğiniz diğer değerli bilgileri ekleyerek kullanıcı deneyimini geliştirin.';
$string['snapfootercolors'] = 'Site altbilgi renkleri';
$string['snapfootercolorsdesc'] = 'Altbilginin renkleri değiştirilebilir: Arka plan rengini ve/veya metin rengini değiştirmek için bunları aşağıdaki renk seçicilerden seçin.';
$string['snapfooterbgcolor'] = 'Altbilgi arka plan rengi';
$string['snapfootertxtcolor'] = 'Altbilgi metin rengi';
$string['enableblockmyoverviewwarning'] = 'Ders özeti bloku devre dışı bırakıldı. Kursları görüntülemek için lütfen engeli etkinleştirin.';
$string['collapseicon'] = 'Şunun içeriğini daraltın:';
$string['expandicon'] = 'Şunun içeriğini genişletin:';
