<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Language file.
 *
 * @package     theme_trema
 * @copyright   2019-2024 Trema - {@link https://trema.tech/}
 * @copyright   2023-2024 TNG Consulting Inc. - {@link https://www.tngconsulting.ca/}
 * @author      Rodrigo Mady
 * @author      Trevor Furtado
 * @author      Michael Milette
 * @license     http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['adminarea'] = 'Only Administrators can see blocks in this area.';
$string['admindashboard'] = 'Admin Dashboard';
$string['alert'] = 'Alerts';
$string['available'] = 'Available';
$string['bannerheight'] = 'Frontpage banner height';
$string['bannerheight_desc'] = 'Set the height of the frontpage banner.';
$string['bannertitlesfont'] = 'Banner title font';
$string['bannertitlesfont_desc'] = 'This font will be used for front page banner titles.';
$string['bannertitlespacing'] = 'Frontpage banner title spacing';
$string['bannertitlespacing_desc'] = 'Frontpage banner title';
$string['bannertitletransform'] = 'Banner Title transform';
$string['bannertitletransform_desc'] = 'Frontpage banner title';
$string['black'] = 'Black';
$string['bodybackgroundcolor'] = 'Body background color';
$string['bodybackgroundcolor_desc'] = 'Body background color ';
$string['cachedef_dashboardadmin'] = 'Cache for Admin dashboard';
$string['card'] = 'Card';
$string['cardcontacts'] = 'Course contacts';
$string['cardcontacts_desc'] = 'Show course\'s contacts (e.g. teachers). Not applicable to all layout formats and only appears if teachers have been assigned to the course.';
$string['cardicon'] = 'Card icon';
$string['cardicon_desc'] = 'See here the list of all Font Awesome available icons: <a href="https://fontawesome.com/v6/icons/" target="_blank">https://fontawesome.com/v6/icons/</a>';
$string['cardiconcolor'] = 'Card icon color';
$string['cardlink'] = 'Card link';
$string['cardsubtitle'] = 'Card subtitle';
$string['cardsubtitle_default'] = 'The description of this card goes here. Several lines of text can be placed in this space.';
$string['cardtitle'] = 'Card title';
$string['cardtitle_default'] = 'Card Title';
$string['carrouselbtnclass'] = 'Frontpage button HTML class';
$string['carrouselbtnclass_desc'] = 'You can change the style of the button by choosing a different class.';
$string['carrouselbtnhref'] = 'Button link {$a}';
$string['carrouselbtnhref_desc'] = 'Button link for frontpage image {$a}.';
$string['carrouselbtntext'] = 'Button text {$a}';
$string['carrouselbtntext_desc'] = 'Button text for link in frontpage image {$a}.';
$string['choosereadme'] = 'Trema is built on the Moodle Boost theme, using Bootstrap 4 and Mustache templates.';
$string['colors'] = 'Colors';
$string['configtitle'] = 'Trema';
$string['courseenrolmentpagecard'] = 'Card';
$string['courseenrolmentpageformat'] = 'Course enrolment page format';
$string['courseenrolmentpageformat_desc'] = 'Select how the course description will appear on the course enrolment page.';
$string['courseenrolmentpagefull'] = 'Full page';
$string['courselistsettings'] = 'Course lists';
$string['courselistsettings_desc'] = 'When viewing course listings on the Front Page, All Courses, Categories and search results, you can choose what information to include, the layout of how it is going to look, and filter courses based on language and tags.';
$string['coursescards'] = 'Courses cards';
$string['custommenualignment'] = 'Primary navigation alignment';
$string['custommenualignment_desc'] = 'Choose whether you want the main menu at the top of the page to be aligned to the left, middle or to the right.';
$string['dark'] = 'Dark';
$string['defaultfooter'] = 'Footer';
$string['defaultfooter_default'] = '<div class="row">
  <div class="col-md-4 col-sm-6 col-12">
    <h3 class="h5 mb-4">Trema Campus</h3>
    <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod
      tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim
      veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea
      commodo consequat.</p>
  </div>
  <div class="col-md-3 col-sm-12 ml-auto">
    <h3 class="h5 mb-4">Contact Us</h3>
    <ul class="labeled-icons">
      <li class="mb-2"><i class="fa fa-info-circle fa-fw"></i>&nbsp;<a href="#">FAQ</a></li>
      <li class="mb-2"><i class="fa fa-mortar-board"></i>&nbsp;<a href="#">Registrar\'s office</a></li>
      <li class="mb-2"><i class="fa fa-question-circle fa-fw"></i>&nbsp;<a href="#">Student support</a></li>
      <li class="mb-2"><i class="fa fa-phone fa-fw"></i>&nbsp;<a href="tel:999-555-1212">999-555-1212</a></li>
      <li class="mb-2"><i class="fa fa-clock fa-fw"></i>&nbsp;Monday-Friday 8 AM to 4 PM</li>
    </ul>
  </div>
  <div class="col-md-3 col-sm-6 col-12">
    <h3 class="h5 mb-4">Stay in touch</h3>
    <ul class="labeled-icons">
      <li class="mb-2"><i class="fa fa-envelope fa-fw" aria-hidden="true"></i>&nbsp;<a href="#">Sign up for our newsletter</a></li>
      <li class="mb-2"><i class="fa fa-facebook fa-fw" aria-hidden="true"></i>&nbsp;<a href="https://facebook.com">Facebook</a></li>
      <li class="mb-2"><i class="fa fa-twitter fa-fw" aria-hidden="true"></i>&nbsp;<a href="https://twitter.com">Twitter</a></li>
      <li class="mb-2"><i class="fa fa-linkedin fa-fw" aria-hidden="true"></i>&nbsp;<a href="https://linkedin.com">LinkedIn</a></li>
      <li class="mb-2"><i class="fa fa-youtube fa-fw" aria-hidden="true"></i>&nbsp;<a href="https://youtube.com">YouTube</a></li>
    </ul>
  </div>
</div>';
$string['defaultfooter_desc'] = 'Default content from footer';
$string['defaultfrontpagebody'] = 'Frontpage Body';
$string['defaultfrontpagebody_desc'] = 'Default content from frontpage body';
$string['diskusage'] = 'Data storage space';
$string['drawerbgcolor'] = 'Drawer Background Color';
$string['drawerbgcolor_desc']  = 'The background color of the drawers.';
$string['enableadmindashboard'] = 'Admin Dashboard';
$string['enableadmindashboard_desc'] = 'Enable if you want to show additional site information in admin dashboard: <img class="img-responsive" src="{$a}">';
$string['enablefooterinfo'] = 'Footer Info';
$string['enablefooterinfo_desc'] = 'Enable to show additional links and information in the footer:<br><img class="img-responsive" src="{$a}">';
$string['enabletremafooter'] = 'Enable Trema Footer';
$string['enabletremafooter_desc'] = 'Enable Trema Footer instead of Boost popup footer';
$string['enabletremalines'] = 'Enable Trema Lines';
$string['enabletremalines_desc'] = 'Enable Trema Lines: <br> <img class="img-responsive" src="{$a}">';
$string['favicon'] = 'Custom favicon';
$string['favicon_desc'] = 'Upload your own favicon. It should be an .ico file.';
$string['fonts'] = 'Fonts';
$string['fontscolorssettings'] = 'Fonts and Colors';
$string['footerbgcolor'] = 'Footer Background Color';
$string['footerbgcolor_desc']  = 'The background color of the footer.';
$string['footeropacity'] = 'Footer opacity';
$string['footeropacity_desc'] = 'Footer background opacity (0 = completely transparent). This can be especially nice if you set a background image.';
$string['footertitle'] = 'Theme Trema';
$string['frontpage'] = 'Frontpage';
$string['frontpagebanner'] = 'Frontpage banner.';
$string['frontpagebanner_desc'] = 'Upload the image file to be inserted in the frontpage. Will replace the default image of a forest.';
$string['frontpagebannercontentalign'] = 'Banner text alignment.';
$string['frontpagebannercontentalign_desc'] = 'Alignment of the text and button that appear in the banners.';
$string['frontpagebuttonclass'] = 'Frontpage button HTML class';
$string['frontpagebuttonclass_desc'] = 'You can change the style of the button by choosing another class.';
$string['frontpagebuttonhref'] = 'Frontpage button href';
$string['frontpagebuttonhref_desc'] = 'Choose the value of the button\'s href attribute.';
$string['frontpagebuttontext'] = 'Frontpage button text';
$string['frontpagebuttontext_default'] = 'Learn more';
$string['frontpagecards'] = 'Frontpage cards';
$string['frontpagecardssubtitle'] = 'The description of the cards section goes here. Several lines of text can be placed in this space.';
$string['frontpagecardstitle'] = 'Title of cards section';
$string['frontpagecontent'] = 'Frontpage Content';
$string['frontpageenablecards'] = 'Enable frontpage cards';
$string['frontpageenablecards_desc'] = 'Uncheck if you want to hide the area below: <img class="img-responsive" src="{$a}">';
$string['frontpageenabledarkoverlay'] = 'Frontpage banner dark overlay';
$string['frontpageenabledarkoverlay_desc'] = 'When enabled, this will apply a dark overlay to the banner image on the frontpage.';
$string['frontpageimage'] = 'Frontpage banner image {$a}';
$string['frontpageimage_desc'] = 'Image {$a} to show in frontpage banner.';
$string['frontpageimages'] = 'Frontpage banner';
$string['frontpagesubtitle'] = 'Frontpage subtitle.';
$string['frontpagesubtitle_default'] = 'This is a banner subtitle,<br>with multiple lines of text.';
$string['frontpagetitle'] = 'Frontpage title.';
$string['frontpagetitle_default'] = 'Banner title';
$string['h1font'] = 'Page headings';
$string['h1font_desc'] = 'This font will be used for H1 level headings except for banner titles on the front page.';
$string['headerbgcolor'] = 'Header Background Color';
$string['headerbgcolor_desc']  = 'The background color of the header.';
$string['hideprimarynavigationitems'] = 'Hide primary menu items';
$string['hideprimarynavigationitems_desc'] = 'Choose which of the built-in primary (custom) menu items that you would like to remove.';
$string['hxfont'] = 'Headings';
$string['hxfont_desc'] = 'This font will be used for H2 to H6 headings.';
$string['image'] = 'Image {$a}';
$string['imagelink'] = 'Image link';
$string['imagelink_desc'] = 'Button with a link in image {$a}.';
$string['light'] = 'Light';
$string['link'] = 'Link';
$string['linkdecoration'] = 'Link style';
$string['linkdecoration_desc'] = 'Links can either be underlined or in bold.';
$string['login'] = 'Login';
$string['loginbackgroundimage'] = 'Login background image';
$string['loginboxcontentalign'] = 'Login box alignment.';
$string['loginboxcontentalign_desc'] = 'Alignment of the text and button that appear in the Login Page.';
$string['loginbtnbgcolor'] = 'Log In button background color';
$string['loginbtnbgcolor_desc'] = 'The background colour of the Log In button in the header.';
$string['loginpagecreatefirst'] = 'Display \'Create account\' box first';
$string['loginpagecreatefirst_desc'] = 'If checked, display the \'Create account\' box first. The default is to display the login box first.';
$string['loginpagestyle'] = 'Login page style';
$string['loginshowloginform'] = 'Show login form';
$string['loginshowloginform_desc'] = 'Before disabling the login form, ensure that administrators have an alternate method to Sign in to the site.';
$string['modal'] = 'Modal';
$string['navfilter'] = 'Filter navigation';
$string['navfilter_desc'] = 'Process the custom menu through Moodle filters that are set to apply to <strong>Content and Headings</strong>. Useful for enabling dynamic custom menu items.';
$string['numberofcards'] = 'Number of cards';
$string['numberofcards_desc'] = 'Select the number of cards you want to add then click SAVE to show the input fields.';
$string['numberofimages']  = "Number of images in frontpage banner";
$string['numberofimages_desc']  = 'Select the number of images you want to add then click SAVE to show the input fields. If it is more than one, the carousel will be activated automatically.';
$string['pluginname'] = 'Trema';
$string['popover'] = 'Popover';
$string['primarycolor'] = 'Brand colour';
$string['primarycolor_desc'] = 'The main colour.';
$string['privacy:metadata'] = 'The Trema theme does not store any individual user data.';
$string['region-side-admin'] = 'Only admins';
$string['rememberusername'] = 'Remember user';
$string['samebasecolor'] = 'Same as background color';
$string['sameprimarycolor'] = 'Same as primary color';
$string['samesecondarycolor'] = 'Same as secondary color';
$string['secondarycolor'] = 'Secondary colour';
$string['secondarycolor_desc'] = 'The secondary colour.';
$string['seemore'] = 'See more';
$string['showactivityicons'] = 'Show activity icons';
$string['showactivityicons_desc'] = 'Show activity icons in courses.';
$string['showbranding'] = 'Branding';
$string['showbranding_desc'] = 'Show or hide Moodle and Trema branding and copyright in the page footer.';
$string['showcategories'] = 'Show categories';
$string['showcategories_desc'] = 'Enable to show categories on frontpage.';
$string['showehiddencategorycourses'] = 'Show courses in hidden categories';
$string['showehiddencategorycourses_desc'] = 'Deselect this option to hide courses if they are in or in a hidden category or under one or more hidden parent categories. These courses will still be available by direct URL, if the user has the capability to view hidden categories or edit/update the course.';
$string['showfrontpagelinkstopages'] = 'Frontpage pages';
$string['showfrontpagelinkstopages_desc'] = 'Uncheck this setting to hide links to pages on the Frontpage. These pages can be useful when you want to create additional pages of information, About us, Contact Us, Help/FAQ, etc.';
$string['shownactivitynavigation'] = 'Show activity navigation';
$string['shownactivitynavigation_desc'] = 'Show activity navigation at the bottom of activity pages.';
$string['showprofile_heading'] = 'Select the sections and fields to be displayed when user\'s edit their profile.';
$string['showprofilesection_desc'] = 'Show the whole section.';
$string['showumlogoutlink'] = 'Log out link';
$string['showumlogoutlink_desc'] = 'Disable to hide the User Menu Log Out link.';
$string['sitefont'] = 'Site font';
$string['sitefont_desc'] = 'This font will be used for all content except for page titles and headings.';
$string['softness'] = 'Softness';
$string['softness_desc'] = 'Enable for a softer look by rounding some corners.';
$string['styleguide'] = 'Style Guide';
$string['subtitle'] = 'Subtitle';
$string['subtitle_default'] = 'This is the default subtitle. You can modify or remove this in the Trema theme settings.';
$string['subtitle_desc']  = 'Subtitle to show in frontpage image {$a}';
$string['summarybutton_text'] = 'Description';
$string['summarycourselink_text'] = 'Go to the course';
$string['summarytype'] = 'Summary type';
$string['summarytype_desc'] = 'Choose the type of course summary button that appears in course cards.';
$string['texttransform'] = 'Text transformation';
$string['texttransform_capitalize'] = 'Capitalize each word';
$string['texttransform_desc'] = 'Automatically transforms navigation, buttons, user menu, headings and search input text.';
$string['texttransform_lowercase'] = 'All lowercase';
$string['texttransform_none'] = 'No transformation';
$string['texttransform_uppercase'] = 'All uppercase';
$string['title'] = 'Title';
$string['title_desc']  = 'Title to show in frontpage image {$a}';
$string['total'] = 'Total';
$string['totop'] = 'Go to top';
$string['white'] = 'White';
